/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.plugin.descriptor.PluginDescriptor;
import org.apache.maven.api.services.xml.PluginXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.services.xml.XmlWriterException;
import org.apache.maven.api.services.xml.XmlWriterRequest;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.StaxLocation;
import org.apache.maven.plugin.descriptor.io.PluginDescriptorStaxReader;
import org.apache.maven.plugin.descriptor.io.PluginDescriptorStaxWriter;

@Named
@Singleton
public class DefaultPluginXmlFactory
implements PluginXmlFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginDescriptor read(@Nonnull XmlReaderRequest request) throws XmlReaderException {
        ImplUtils.nonNull(request, "request");
        Path path = request.getPath();
        URL url = request.getURL();
        Reader reader = request.getReader();
        InputStream inputStream = request.getInputStream();
        if (path == null && url == null && reader == null && inputStream == null) {
            throw new IllegalArgumentException("path, url, reader or inputStream must be non null");
        }
        try {
            PluginDescriptorStaxReader xml = new PluginDescriptorStaxReader();
            xml.setAddDefaultEntities(request.isAddDefaultEntities());
            if (inputStream != null) {
                return xml.read(inputStream, request.isStrict());
            }
            if (reader != null) {
                return xml.read(reader, request.isStrict());
            }
            if (path != null) {
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    PluginDescriptor pluginDescriptor = xml.read(is, request.isStrict());
                    return pluginDescriptor;
                }
            }
            try (InputStream is = url.openStream();){
                PluginDescriptor pluginDescriptor = xml.read(is, request.isStrict());
                return pluginDescriptor;
            }
        }
        catch (Exception e) {
            throw new XmlReaderException("Unable to read plugin: " + StaxLocation.getMessage(e), StaxLocation.getLocation(e), e);
        }
    }

    public void write(XmlWriterRequest<PluginDescriptor> request) throws XmlWriterException {
        block11: {
            ImplUtils.nonNull(request, "request");
            PluginDescriptor content = ImplUtils.nonNull((PluginDescriptor)request.getContent(), "content");
            Path path = request.getPath();
            OutputStream outputStream = request.getOutputStream();
            Writer writer = request.getWriter();
            if (writer == null && outputStream == null && path == null) {
                throw new IllegalArgumentException("writer, outputStream or path must be non null");
            }
            try {
                if (writer != null) {
                    new PluginDescriptorStaxWriter().write(writer, content);
                    break block11;
                }
                if (outputStream != null) {
                    new PluginDescriptorStaxWriter().write(outputStream, content);
                    break block11;
                }
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    new PluginDescriptorStaxWriter().write(outputStream, content);
                }
            }
            catch (Exception e) {
                throw new XmlWriterException("Unable to write plugin: " + StaxLocation.getMessage(e), StaxLocation.getLocation(e), e);
            }
        }
    }

    public static PluginDescriptor fromXml(@Nonnull String xml) throws XmlReaderException {
        return (PluginDescriptor)new DefaultPluginXmlFactory().fromXmlString(xml);
    }

    public static String toXml(@Nonnull PluginDescriptor content) throws XmlWriterException {
        return new DefaultPluginXmlFactory().toXmlString(content);
    }
}

