/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.impl.AbstractNode;
import org.apache.maven.impl.DefaultDependencyResolverResult;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.PathModularizationCache;
import org.apache.maven.impl.RequestTraceHelper;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.scope.ResolutionScope;

@Named
@Singleton
public class DefaultDependencyResolver
implements DependencyResolver {
    @Nonnull
    public DependencyResolverResult collect(@Nonnull DependencyResolverRequest request) throws DependencyResolverException, IllegalArgumentException {
        ImplUtils.nonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(session, request);
        try {
            List remoteRepositories;
            Collection managedDependencies;
            Collection dependencies;
            DependencyCoordinates root;
            Artifact rootArtifact;
            if (request.getProject().isPresent()) {
                Project project = (Project)request.getProject().get();
                rootArtifact = project.getPomArtifact();
                root = null;
                dependencies = project.getDependencies();
                managedDependencies = project.getManagedDependencies();
                remoteRepositories = request.getRepositories() != null ? request.getRepositories() : ((ProjectManager)session.getService(ProjectManager.class)).getRemoteProjectRepositories(project);
            } else {
                rootArtifact = request.getRootArtifact().orElse(null);
                root = request.getRoot().orElse(null);
                dependencies = request.getDependencies();
                managedDependencies = request.getManagedDependencies();
                remoteRepositories = request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories();
            }
            ResolutionScope resolutionScope = null;
            if (request.getPathScope() != null) {
                resolutionScope = (ResolutionScope)session.getSession().getScopeManager().getResolutionScope(request.getPathScope().id()).orElseThrow();
            }
            CollectRequest collectRequest = new CollectRequest().setRootArtifact(rootArtifact != null ? session.toArtifact(rootArtifact) : null).setRoot(root != null ? session.toDependency(root, false) : null).setDependencies(session.toDependencies(dependencies, false)).setManagedDependencies(session.toDependencies(managedDependencies, true)).setRepositories(session.toRepositories(remoteRepositories)).setRequestContext(trace.context()).setTrace(trace.trace());
            collectRequest.setResolutionScope(resolutionScope);
            RepositorySystemSession systemSession = session.getSession();
            if (request.getVerbose()) {
                systemSession = new DefaultRepositorySystemSession(systemSession).setConfigProperty("aether.conflictResolver.verbose", (Object)true).setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            }
            try {
                CollectResult result = session.getRepositorySystem().collectDependencies(systemSession, collectRequest);
                DefaultDependencyResolverResult defaultDependencyResolverResult = new DefaultDependencyResolverResult(null, null, result.getExceptions(), session.getNode(result.getRoot(), request.getVerbose()), 0);
                return defaultDependencyResolverResult;
            }
            catch (DependencyCollectionException e) {
                throw new DependencyResolverException("Unable to collect dependencies", (Throwable)e);
            }
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }

    @Nonnull
    public List<Node> flatten(@Nonnull Session s, @Nonnull Node node, @Nullable PathScope scope) throws DependencyResolverException {
        InternalSession session = InternalSession.from(s);
        DependencyNode root = ImplUtils.cast(AbstractNode.class, node, "node").getDependencyNode();
        List dependencies = session.getRepositorySystem().flattenDependencyNodes(session.getSession(), root, DefaultDependencyResolver.getScopeDependencyFilter(scope));
        dependencies.remove(root);
        return ImplUtils.map(dependencies, session::getNode);
    }

    private static DependencyFilter getScopeDependencyFilter(PathScope scope) {
        if (scope == null) {
            return null;
        }
        Set scopes = scope.dependencyScopes().stream().map(DependencyScope::id).collect(Collectors.toSet());
        return (n, p) -> {
            Dependency d = n.getDependency();
            return d == null || scopes.contains(d.getScope());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyResolverResult resolve(DependencyResolverRequest request) throws DependencyResolverException, ArtifactResolverException {
        InternalSession session = InternalSession.from((Session)ImplUtils.nonNull(request, "request").getSession());
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(session, request);
        try {
            DependencyResolverResult result;
            List repositories;
            DependencyResolverResult collectorResult = this.collect(request);
            List list = request.getRepositories() != null ? request.getRepositories() : (repositories = request.getProject().isPresent() ? ((ProjectManager)session.getService(ProjectManager.class)).getRemoteProjectRepositories((Project)request.getProject().get()) : session.getRemoteRepositories());
            if (request.getRequestType() == DependencyResolverRequest.RequestType.COLLECT) {
                result = collectorResult;
            } else {
                List<Node> nodes = this.flatten(session, collectorResult.getRoot(), request.getPathScope());
                List coordinates = nodes.stream().map(Node::getDependency).filter(Objects::nonNull).map(Artifact::toCoordinates).collect(Collectors.toList());
                Predicate filter = request.getPathTypeFilter();
                if (request.getRequestType() == DependencyResolverRequest.RequestType.FLATTEN) {
                    DefaultDependencyResolverResult flattenResult = new DefaultDependencyResolverResult(null, null, collectorResult.getExceptions(), collectorResult.getRoot(), nodes.size());
                    for (Node node : nodes) {
                        flattenResult.addNode(node);
                    }
                    result = flattenResult;
                } else {
                    PathModularizationCache cache = new PathModularizationCache();
                    DefaultDependencyResolverResult resolverResult = new DefaultDependencyResolverResult(null, cache, collectorResult.getExceptions(), collectorResult.getRoot(), nodes.size());
                    ArtifactResolverResult artifactResolverResult = ((ArtifactResolver)session.getService(ArtifactResolver.class)).resolve((Session)session, coordinates, repositories);
                    for (Node node : nodes) {
                        Path path = node.getArtifact() != null ? artifactResolverResult.getResult(node.getArtifact().toCoordinates()).getPath() : null;
                        try {
                            resolverResult.addDependency(node, node.getDependency(), filter, path);
                        }
                        catch (IOException e) {
                            throw DefaultDependencyResolver.cannotReadModuleInfo(path, e);
                        }
                    }
                    result = resolverResult;
                }
            }
            DependencyResolverResult dependencyResolverResult = result;
            return dependencyResolverResult;
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }

    private static DependencyResolverException cannotReadModuleInfo(Path path, IOException cause) {
        return new DependencyResolverException("Cannot read module information of " + path, (Throwable)cause);
    }
}

