/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.Objects;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.impl.AetherDependencyWrapper;
import org.apache.maven.impl.DefaultModelVersionParser;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.graph.Dependency;

public class DefaultDependency
extends AetherDependencyWrapper
implements org.apache.maven.api.Dependency {
    private final String key = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getExtension() + (String)(!this.getClassifier().isEmpty() ? ":" + this.getClassifier() : "") + ":" + this.getVersion();

    public DefaultDependency(@Nonnull InternalSession session, @Nonnull Dependency dependency) {
        super(session, dependency);
    }

    public String key() {
        return this.key;
    }

    public Version getVersion() {
        return this.session.parseVersion(this.dependency.getArtifact().getVersion());
    }

    public Version getBaseVersion() {
        return this.session.parseVersion(this.dependency.getArtifact().getBaseVersion());
    }

    public boolean isSnapshot() {
        return DefaultModelVersionParser.checkSnapshot(this.dependency.getArtifact().getVersion());
    }

    public boolean isOptional() {
        return this.dependency.isOptional();
    }

    @Nonnull
    public DependencyCoordinates toCoordinates() {
        return this.session.createDependencyCoordinates(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof Artifact)) return false;
        Artifact artifact = (Artifact)o;
        if (!Objects.equals(this.key(), artifact.key())) return false;
        return true;
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

