/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.Collection;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactDeployerException;
import org.apache.maven.api.services.ArtifactDeployerRequest;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;

@Named
@Singleton
public class DefaultArtifactDeployer
implements ArtifactDeployer {
    public void deploy(@Nonnull ArtifactDeployerRequest request) {
        ImplUtils.nonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        Collection artifacts = ImplUtils.nonNull(request.getArtifacts(), "request.artifacts");
        RemoteRepository repository = ImplUtils.nonNull(request.getRepository(), "request.repository");
        try {
            DeployRequest deployRequest = new DeployRequest().setRepository(session.toRepository(repository)).setArtifacts(session.toArtifacts(artifacts));
            session.getRepositorySystem().deploy(session.getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new ArtifactDeployerException("Unable to deploy artifacts", (Exception)((Object)e));
        }
    }
}

