/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.Objects;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.Version;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.impl.DefaultModelVersionParser;
import org.apache.maven.impl.ImplUtils;
import org.apache.maven.impl.InternalSession;
import org.eclipse.aether.artifact.Artifact;

public class DefaultArtifact
implements org.apache.maven.api.Artifact {
    @Nonnull
    protected final InternalSession session;
    @Nonnull
    protected final Artifact artifact;
    protected final String key;

    public DefaultArtifact(@Nonnull InternalSession session, @Nonnull Artifact artifact) {
        this.session = ImplUtils.nonNull(session, "session");
        this.artifact = ImplUtils.nonNull(artifact, "artifact");
        this.key = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getExtension() + (String)(this.getClassifier().isEmpty() ? "" : ":" + this.getClassifier()) + ":" + this.getVersion();
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String key() {
        return this.key;
    }

    @Nonnull
    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    @Nonnull
    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    @Nonnull
    public Version getVersion() {
        return this.session.parseVersion(this.artifact.getVersion());
    }

    public Version getBaseVersion() {
        return this.session.parseVersion(this.artifact.getBaseVersion());
    }

    @Nonnull
    public String getExtension() {
        return this.artifact.getExtension();
    }

    @Nonnull
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public boolean isSnapshot() {
        return DefaultModelVersionParser.checkSnapshot(this.artifact.getVersion());
    }

    @Nonnull
    public ArtifactCoordinates toCoordinates() {
        return this.session.createArtifactCoordinates(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof org.apache.maven.api.Artifact)) return false;
        org.apache.maven.api.Artifact artifact = (org.apache.maven.api.Artifact)o;
        if (!Objects.equals(this.key(), artifact.key())) return false;
        return true;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.artifact.toString();
    }
}

