/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services.model;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.services.ModelSource;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Result;
import org.apache.maven.api.services.model.ModelResolverException;

public interface ModelResolver
extends Service {
    @Nonnull
    public ModelSource resolveModel(@Nonnull Session var1, @Nullable List<RemoteRepository> var2, @Nonnull Parent var3, @Nonnull AtomicReference<Parent> var4) throws ModelResolverException;

    @Nonnull
    public ModelSource resolveModel(@Nonnull Session var1, @Nullable List<RemoteRepository> var2, @Nonnull Dependency var3, @Nonnull AtomicReference<Dependency> var4) throws ModelResolverException;

    @Nonnull
    public ModelResolverResult resolveModel(@Nonnull ModelResolverRequest var1) throws ModelResolverException;

    public record ModelResolverResult(ModelResolverRequest request, ModelSource source, String version) implements Result<ModelResolverRequest>
    {
        @Nonnull
        public ModelResolverRequest getRequest() {
            return this.request;
        }
    }

    public record ModelResolverRequest(@Nonnull Session session, @Nullable RequestTrace trace, @Nullable List<RemoteRepository> repositories, @Nonnull String groupId, @Nonnull String artifactId, @Nonnull String version, @Nullable String classifier) implements Request<Session>
    {
        @Nonnull
        public Session getSession() {
            return this.session;
        }

        @Nullable
        public RequestTrace getTrace() {
            return this.trace;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ModelResolverRequest)) return false;
            ModelResolverRequest that = (ModelResolverRequest)o;
            if (this.repositories != that.repositories) return false;
            if (!Objects.equals(this.groupId, that.groupId)) return false;
            if (!Objects.equals(this.artifactId, that.artifactId)) return false;
            if (!Objects.equals(this.version, that.version)) return false;
            if (!Objects.equals(this.classifier, that.classifier)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.repositories, this.groupId, this.artifactId, this.version, this.classifier);
        }

        @Override
        @Nonnull
        public String toString() {
            return this.getClass().getSimpleName() + "[repositories=" + this.repositories + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", classifier=" + this.classifier + "]";
        }
    }
}

