/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.ReportSet;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryBase;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileInjector;
import org.apache.maven.impl.model.MavenModelMerger;
import org.apache.maven.model.v4.MavenMerger;

@Named
@Singleton
public class DefaultProfileInjector
implements ProfileInjector {
    private static final Map<Model, Map<List<Profile>, Model>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Model KEY = Model.newInstance();
    private final ProfileModelMerger merger = new ProfileModelMerger();

    @Override
    public Model injectProfiles(Model model, List<Profile> profiles, ModelBuilderRequest request, ModelProblemCollector problems) {
        Model result = CACHE.computeIfAbsent(model, k -> new ConcurrentHashMap()).computeIfAbsent(profiles, l -> this.doInjectProfiles(model, profiles));
        return result == KEY ? model : result;
    }

    private Model doInjectProfiles(Model model, List<Profile> profiles) {
        Model orgModel = model;
        for (Profile profile : profiles) {
            if (profile == null) continue;
            Model.Builder builder = Model.newBuilder((Model)model);
            this.merger.mergeModelBase((ModelBase.Builder)builder, (ModelBase)model, (ModelBase)profile);
            if (profile.getBuild() != null) {
                Build build = model.getBuild() != null ? model.getBuild() : Build.newInstance();
                Build.Builder bbuilder = Build.newBuilder((Build)build);
                this.merger.mergeBuildBase((BuildBase.Builder)bbuilder, (BuildBase)build, profile.getBuild());
                builder.build(bbuilder.build());
            }
            model = builder.build();
        }
        return model == orgModel ? KEY : model;
    }

    protected static class ProfileModelMerger
    extends MavenModelMerger {
        protected ProfileModelMerger() {
        }

        public void mergeModelBase(ModelBase.Builder builder, ModelBase target, ModelBase source) {
            this.mergeModelBase(builder, target, source, true, Collections.emptyMap());
        }

        public void mergeBuildBase(BuildBase.Builder builder, BuildBase target, BuildBase source) {
            this.mergeBuildBase(builder, target, source, true, Collections.emptyMap());
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer.Builder builder, PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                List tgt = target.getPlugins();
                LinkedHashMap master = new LinkedHashMap(tgt.size() * 2);
                for (Plugin element : tgt) {
                    Object key = this.getPluginKey().apply(element);
                    master.put(key, element);
                }
                LinkedHashMap predecessors = new LinkedHashMap();
                ArrayList<Plugin> pending = new ArrayList<Plugin>();
                for (Plugin element : src) {
                    Object key = this.getPluginKey().apply(element);
                    Plugin existing = (Plugin)master.get(key);
                    if (existing != null) {
                        existing = this.mergePlugin(existing, element, sourceDominant, context);
                        master.put(key, existing);
                        if (pending.isEmpty()) continue;
                        predecessors.put(key, pending);
                        pending = new ArrayList();
                        continue;
                    }
                    pending.add(element);
                }
                ArrayList<Plugin> result = new ArrayList<Plugin>(src.size() + tgt.size());
                for (Map.Entry entry : master.entrySet()) {
                    List pre = (List)predecessors.get(entry.getKey());
                    if (pre != null) {
                        result.addAll(pre);
                    }
                    result.add((Plugin)entry.getValue());
                }
                result.addAll(pending);
                builder.plugins(result);
            }
        }

        @Override
        protected void mergePlugin_Executions(Plugin.Builder builder, Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getExecutions();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getExecutions();
                LinkedHashMap merged = new LinkedHashMap((src.size() + tgt.size()) * 2);
                for (PluginExecution element : tgt) {
                    key = this.getPluginExecutionKey().apply(element);
                    merged.put(key, element);
                }
                for (PluginExecution element : src) {
                    key = this.getPluginExecutionKey().apply(element);
                    PluginExecution existing = (PluginExecution)merged.get(key);
                    if (existing != null) {
                        element = this.mergePluginExecution(existing, element, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                builder.executions(merged.values());
            }
        }

        @Override
        protected void mergeReporting_Plugins(Reporting.Builder builder, Reporting target, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getPlugins();
                LinkedHashMap merged = new LinkedHashMap((src.size() + tgt.size()) * 2);
                for (ReportPlugin element : tgt) {
                    key = this.getReportPluginKey().apply(element);
                    merged.put(key, element);
                }
                for (ReportPlugin element : src) {
                    key = this.getReportPluginKey().apply(element);
                    ReportPlugin existing = (ReportPlugin)merged.get(key);
                    if (existing != null) {
                        element = this.mergeReportPlugin(existing, element, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                builder.plugins(merged.values());
            }
        }

        @Override
        protected void mergeReportPlugin_ReportSets(ReportPlugin.Builder builder, ReportPlugin target, ReportPlugin source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getReportSets();
            if (!src.isEmpty()) {
                Object key;
                List tgt = target.getReportSets();
                LinkedHashMap merged = new LinkedHashMap((src.size() + tgt.size()) * 2);
                for (ReportSet element : tgt) {
                    key = this.getReportSetKey().apply(element);
                    merged.put(key, element);
                }
                for (ReportSet element : src) {
                    key = this.getReportSetKey().apply(element);
                    ReportSet existing = (ReportSet)merged.get(key);
                    if (existing != null) {
                        element = this.mergeReportSet(existing, element, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                builder.reportSets(merged.values());
            }
        }

        @Override
        protected MavenMerger.KeyComputer<Repository> getRepositoryKey() {
            return RepositoryBase::getId;
        }
    }
}

