/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.Interpolator;
import org.apache.maven.api.services.InterpolatorException;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ProjectBuilderException;
import org.apache.maven.api.services.model.PathTranslator;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.RootLocator;

public class DefaultProfileActivationContext
implements ProfileActivationContext {
    private final PathTranslator pathTranslator;
    private final RootLocator rootLocator;
    private final Interpolator interpolator;
    private List<String> activeProfileIds = Collections.emptyList();
    private List<String> inactiveProfileIds = Collections.emptyList();
    private Map<String, String> systemProperties = Collections.emptyMap();
    private Map<String, String> userProperties = Collections.emptyMap();
    private Model model;
    private final ThreadLocal<Record> records = new ThreadLocal();

    public DefaultProfileActivationContext(PathTranslator pathTranslator, RootLocator rootLocator, Interpolator interpolator) {
        this.pathTranslator = pathTranslator;
        this.rootLocator = rootLocator;
        this.interpolator = interpolator;
    }

    Record start() {
        Record record = this.records.get();
        this.records.set(new Record());
        return record;
    }

    Record stop(Record previous) {
        Record record = this.records.get();
        this.records.set(previous);
        record.usedActiveProfiles.values().removeIf(value -> value == false);
        record.usedInactiveProfiles.values().removeIf(value -> value == false);
        return record;
    }

    @Override
    public boolean isProfileActive(String profileId) {
        Record record = this.records.get();
        if (record != null) {
            return record.usedActiveProfiles.computeIfAbsent(profileId, this.activeProfileIds::contains);
        }
        return this.activeProfileIds.contains(profileId);
    }

    public DefaultProfileActivationContext setActiveProfileIds(List<String> activeProfileIds) {
        this.activeProfileIds = DefaultProfileActivationContext.unmodifiable(activeProfileIds);
        return this;
    }

    @Override
    public boolean isProfileInactive(String profileId) {
        Record record = this.records.get();
        if (record != null) {
            return record.usedInactiveProfiles.computeIfAbsent(profileId, this.inactiveProfileIds::contains);
        }
        return this.inactiveProfileIds.contains(profileId);
    }

    public DefaultProfileActivationContext setInactiveProfileIds(List<String> inactiveProfileIds) {
        this.inactiveProfileIds = DefaultProfileActivationContext.unmodifiable(inactiveProfileIds);
        return this;
    }

    @Override
    public String getSystemProperty(String key) {
        Record record = this.records.get();
        if (record != null) {
            return record.usedSystemProperties.computeIfAbsent(key, this.systemProperties::get);
        }
        return this.systemProperties.get(key);
    }

    public DefaultProfileActivationContext setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = DefaultProfileActivationContext.unmodifiable(systemProperties);
        return this;
    }

    @Override
    public String getUserProperty(String key) {
        Record record = this.records.get();
        if (record != null) {
            return record.usedUserProperties.computeIfAbsent(key, this.userProperties::get);
        }
        return this.userProperties.get(key);
    }

    public DefaultProfileActivationContext setUserProperties(Map<String, String> userProperties) {
        this.userProperties = DefaultProfileActivationContext.unmodifiable(userProperties);
        return this;
    }

    @Override
    public String getModelArtifactId() {
        Record record = this.records.get();
        if (record != null) {
            return record.usedModelInfos.computeIfAbsent(ModelInfo.ArtifactId, k -> this.model.getArtifactId());
        }
        return this.model.getArtifactId();
    }

    @Override
    public String getModelPackaging() {
        Record record = this.records.get();
        if (record != null) {
            return record.usedModelInfos.computeIfAbsent(ModelInfo.Packaging, k -> this.model.getPackaging());
        }
        return this.model.getPackaging();
    }

    @Override
    public String getModelProperty(String key) {
        Record record = this.records.get();
        if (record != null) {
            return record.usedModelProperties.computeIfAbsent(key, k -> (String)this.model.getProperties().get(k));
        }
        return (String)this.model.getProperties().get(key);
    }

    @Override
    public String getModelBaseDirectory() {
        Record record = this.records.get();
        if (record != null) {
            return record.usedModelInfos.computeIfAbsent(ModelInfo.BaseDirectory, k -> this.doGetModelBaseDirectory());
        }
        return this.doGetModelBaseDirectory();
    }

    private String doGetModelBaseDirectory() {
        Path basedir = this.model.getProjectDirectory();
        return basedir != null ? basedir.toAbsolutePath().toString() : null;
    }

    @Override
    public String getModelRootDirectory() {
        Record record = this.records.get();
        if (record != null) {
            return record.usedModelInfos.computeIfAbsent(ModelInfo.RootDirectory, k -> this.doGetModelRootDirectory());
        }
        return this.doGetModelRootDirectory();
    }

    private String doGetModelRootDirectory() {
        Path basedir = this.model != null ? this.model.getProjectDirectory() : null;
        Path rootdir = this.rootLocator != null ? this.rootLocator.findRoot(basedir) : null;
        return rootdir != null ? rootdir.toAbsolutePath().toString() : null;
    }

    public DefaultProfileActivationContext setModel(Model model) {
        this.model = model;
        return this;
    }

    @Override
    public String interpolatePath(String path) throws InterpolatorException {
        if (path == null) {
            return null;
        }
        String absolutePath = this.interpolator.interpolate(path, s -> {
            if ("basedir".equals(s) || "project.basedir".equals(s)) {
                return this.getModelBaseDirectory();
            }
            if ("project.rootDirectory".equals(s)) {
                return this.getModelRootDirectory();
            }
            String r = this.getModelProperty((String)s);
            if (r == null) {
                r = this.getUserProperty((String)s);
            }
            if (r == null) {
                r = this.getSystemProperty((String)s);
            }
            return r;
        });
        return this.pathTranslator.alignToBaseDirectory(absolutePath, this.model.getProjectDirectory());
    }

    @Override
    public boolean exists(String path, boolean enableGlob) throws ModelBuilderException {
        Record record = this.records.get();
        if (record != null) {
            return record.usedExists.computeIfAbsent(new ExistRequest(path, enableGlob), r -> this.doExists(r.path, r.enableGlob));
        }
        return this.doExists(path, enableGlob);
    }

    private boolean doExists(String path, boolean enableGlob) throws ModelBuilderException {
        String glob;
        String fixed;
        String pattern = this.interpolatePath(path);
        if (enableGlob) {
            int firstWildcardIndex;
            int asteriskIndex = pattern.indexOf(42);
            int questionMarkIndex = pattern.indexOf(63);
            int n = questionMarkIndex < 0 ? asteriskIndex : (firstWildcardIndex = asteriskIndex < 0 ? questionMarkIndex : Math.min(asteriskIndex, questionMarkIndex));
            if (firstWildcardIndex < 0) {
                fixed = pattern;
                glob = "";
            } else {
                int lastSep = pattern.substring(0, firstWildcardIndex).lastIndexOf(File.separatorChar);
                if (lastSep < 0) {
                    fixed = "";
                    glob = pattern;
                } else {
                    fixed = pattern.substring(0, lastSep);
                    glob = pattern.substring(lastSep + 1);
                }
            }
        } else {
            fixed = pattern;
            glob = "";
        }
        Path fixedPath = Paths.get(fixed, new String[0]);
        return DefaultProfileActivationContext.doExists(fixedPath, glob);
    }

    private static Boolean doExists(final Path fixedPath, String glob) {
        if (fixedPath == null || !Files.exists(fixedPath, new LinkOption[0])) {
            return false;
        }
        if (glob != null && !glob.isEmpty()) {
            try {
                final PathMatcher matcher = fixedPath.getFileSystem().getPathMatcher("glob:" + glob);
                final AtomicBoolean found = new AtomicBoolean(false);
                Files.walkFileTree(fixedPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (found.get() || matcher.matches(fixedPath.relativize(file))) {
                            found.set(true);
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                return found.get();
            }
            catch (IOException e) {
                throw new ProjectBuilderException("Unable to verify file existence for '" + glob + "' inside '" + String.valueOf(fixedPath) + "'", (Exception)e);
            }
        }
        return true;
    }

    private static List<String> unmodifiable(List<String> list) {
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    private static Map<String, String> unmodifiable(Map<String, String> map) {
        return map != null ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    static class Record {
        private final Map<String, Boolean> usedActiveProfiles = new HashMap<String, Boolean>();
        private final Map<String, Boolean> usedInactiveProfiles = new HashMap<String, Boolean>();
        private final Map<String, String> usedSystemProperties = new HashMap<String, String>();
        private final Map<String, String> usedUserProperties = new HashMap<String, String>();
        private final Map<String, String> usedModelProperties = new HashMap<String, String>();
        private final Map<ModelInfo, String> usedModelInfos = new HashMap<ModelInfo, String>();
        private final Map<ExistRequest, Boolean> usedExists = new HashMap<ExistRequest, Boolean>();

        Record() {
        }

        public boolean equals(Object o) {
            if (o instanceof Record) {
                Record record = (Record)o;
                return Objects.equals(this.usedActiveProfiles, record.usedActiveProfiles) && Objects.equals(this.usedInactiveProfiles, record.usedInactiveProfiles) && Objects.equals(this.usedSystemProperties, record.usedSystemProperties) && Objects.equals(this.usedUserProperties, record.usedUserProperties) && Objects.equals(this.usedModelProperties, record.usedModelProperties) && Objects.equals(this.usedModelInfos, record.usedModelInfos) && Objects.equals(this.usedExists, record.usedExists);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.usedActiveProfiles, this.usedInactiveProfiles, this.usedSystemProperties, this.usedUserProperties, this.usedModelProperties, this.usedModelInfos, this.usedExists);
        }

        boolean matches(DefaultProfileActivationContext context) {
            return this.matchesProfiles(this.usedActiveProfiles, context.activeProfileIds) && this.matchesProfiles(this.usedInactiveProfiles, context.inactiveProfileIds) && this.matchesProperties(this.usedSystemProperties, context.systemProperties) && this.matchesProperties(this.usedUserProperties, context.userProperties) && this.matchesProperties(this.usedModelProperties, context.model.getProperties()) && this.matchesModelInfos(this.usedModelInfos, context) && this.matchesExists(this.usedExists, context);
        }

        private boolean matchesProfiles(Map<String, Boolean> expected, List<String> actual) {
            return expected.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), actual.contains(e.getKey())));
        }

        private boolean matchesProperties(Map<String, String> expected, Map<String, String> actual) {
            return expected.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), actual.get(e.getKey())));
        }

        private boolean matchesModelInfos(Map<ModelInfo, String> infos, DefaultProfileActivationContext context) {
            return infos.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), this.getModelValue((ModelInfo)((Object)((Object)e.getKey())), context)));
        }

        private String getModelValue(ModelInfo key, DefaultProfileActivationContext context) {
            return switch (key.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> context.model.getArtifactId();
                case 1 -> context.model.getPackaging();
                case 2 -> context.doGetModelBaseDirectory();
                case 3 -> context.doGetModelRootDirectory();
            };
        }

        private boolean matchesExists(Map<ExistRequest, Boolean> exists, DefaultProfileActivationContext context) {
            return exists.entrySet().stream().allMatch(e -> Objects.equals(e.getValue(), context.doExists(((ExistRequest)e.getKey()).path(), ((ExistRequest)e.getKey()).enableGlob())));
        }
    }

    static enum ModelInfo {
        ArtifactId,
        Packaging,
        BaseDirectory,
        RootDirectory;

    }

    record ExistRequest(String path, boolean enableGlob) {
    }
}

