/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.LifecycleRegistry;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.PackagingRegistry;
import org.apache.maven.api.services.model.LifecycleBindingsInjector;
import org.apache.maven.impl.model.MavenModelMerger;

@Named
@Singleton
public class DefaultLifecycleBindingsInjector
implements LifecycleBindingsInjector {
    private final LifecycleBindingsMerger merger = new LifecycleBindingsMerger();
    private final LifecycleRegistry lifecycleRegistry;
    private final PackagingRegistry packagingRegistry;

    @Inject
    public DefaultLifecycleBindingsInjector(LifecycleRegistry lifecycleRegistry, PackagingRegistry packagingRegistry) {
        this.lifecycleRegistry = lifecycleRegistry;
        this.packagingRegistry = packagingRegistry;
    }

    @Override
    public Model injectLifecycleBindings(Model model, ModelBuilderRequest request, ModelProblemCollector problems) {
        String packagingId = model.getPackaging();
        Packaging packaging = this.packagingRegistry.lookup(packagingId).orElse(null);
        if (packaging == null) {
            problems.add(BuilderProblem.Severity.ERROR, ModelProblem.Version.BASE, "Unknown packaging: " + packagingId, model.getLocation((Object)"packaging"));
            return model;
        }
        HashMap plugins = new HashMap(packaging.plugins());
        this.lifecycleRegistry.stream().filter(lf -> !plugins.containsKey(lf.id())).forEach(lf -> plugins.put(lf.id(), PluginContainer.newBuilder().plugins(lf.phases().stream().flatMap(phase -> phase.plugins().stream()).toList()).build()));
        LinkedHashMap allPlugins = new LinkedHashMap();
        plugins.values().stream().flatMap(pc -> pc.getPlugins().stream()).forEach(p -> this.addPlugin(allPlugins, (Plugin)p));
        Model lifecycleModel = Model.newBuilder().build(Build.newBuilder().plugins(allPlugins.values()).build()).build();
        return this.merger.merge(model, lifecycleModel);
    }

    private void addPlugin(Map<Plugin, Plugin> plugins, Plugin plugin) {
        Plugin cur = plugins.putIfAbsent(plugin, plugin);
        if (cur != null) {
            LinkedHashMap execs = new LinkedHashMap();
            cur.getExecutions().forEach(e -> execs.put(e.getId(), e));
            plugin.getExecutions().forEach(e -> {
                int i = 0;
                Object id = e.getId();
                while (execs.putIfAbsent(id, e.withId((String)id)) != null) {
                    id = e.getId() + "-" + ++i;
                }
            });
            Plugin merged = cur.withExecutions(execs.values());
            plugins.put(merged, merged);
        }
    }

    private static String getExecutionId(Plugin plugin, String goal) {
        String base;
        Set existingIds = plugin != null ? plugin.getExecutions().stream().map(PluginExecution::getId).collect(Collectors.toSet()) : Set.of();
        String id = base = "default-" + goal;
        int index = 1;
        while (existingIds.contains(id)) {
            id = base + "-" + index;
            ++index;
        }
        return id;
    }

    protected static class LifecycleBindingsMerger
    extends MavenModelMerger {
        private static final String PLUGIN_MANAGEMENT = "plugin-management";

        protected LifecycleBindingsMerger() {
        }

        public Model merge(Model target, Model source) {
            Build targetBuild = target.getBuild();
            if (targetBuild == null) {
                targetBuild = Build.newInstance();
            }
            Map<String, PluginManagement> context = Collections.singletonMap(PLUGIN_MANAGEMENT, targetBuild.getPluginManagement());
            Build.Builder builder = Build.newBuilder((Build)targetBuild);
            this.mergePluginContainer_Plugins((PluginContainer.Builder)builder, (PluginContainer)targetBuild, (PluginContainer)source.getBuild(), false, context);
            return target.withBuild(builder.build());
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer.Builder builder, PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                PluginManagement pluginMgmt;
                List tgt = target.getPlugins();
                LinkedHashMap merged = new LinkedHashMap((src.size() + tgt.size()) * 2);
                for (Object element : tgt) {
                    Object key = this.getPluginKey().apply((Plugin)element);
                    merged.put(key, element);
                }
                LinkedHashMap added = new LinkedHashMap();
                for (Plugin element : src) {
                    Object key = this.getPluginKey().apply(element);
                    Plugin existing = (Plugin)merged.get(key);
                    if (existing != null) {
                        element = this.mergePlugin(existing, element, sourceDominant, context);
                    } else {
                        added.put(key, element);
                    }
                    merged.put(key, element);
                }
                if (!added.isEmpty() && (pluginMgmt = (PluginManagement)context.get(PLUGIN_MANAGEMENT)) != null) {
                    for (Plugin managedPlugin : pluginMgmt.getPlugins()) {
                        Object key = this.getPluginKey().apply(managedPlugin);
                        Plugin addedPlugin = (Plugin)added.get(key);
                        if (addedPlugin == null) continue;
                        Plugin plugin = this.mergePlugin(managedPlugin, addedPlugin, sourceDominant, Collections.emptyMap());
                        merged.put(key, plugin);
                    }
                }
                ArrayList result = new ArrayList(merged.values());
                builder.plugins(result);
            }
        }

        @Override
        protected void mergePluginExecution_Priority(PluginExecution.Builder builder, PluginExecution target, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
            if (target.getPriority() > source.getPriority()) {
                builder.priority(source.getPriority());
                builder.location((Object)"priority", source.getLocation((Object)"priority"));
            }
        }
    }
}

