/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginContainer;
import org.apache.maven.api.model.ReportPlugin;
import org.apache.maven.api.model.Reporting;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.InheritanceAssembler;
import org.apache.maven.impl.model.MavenModelMerger;
import org.apache.maven.model.v4.MavenMerger;

@Named
@Singleton
public class DefaultInheritanceAssembler
implements InheritanceAssembler {
    private static final String CHILD_DIRECTORY = "child-directory";
    private static final String CHILD_DIRECTORY_PROPERTY = "project.directory";
    private final MavenMerger merger;

    @Inject
    public DefaultInheritanceAssembler() {
        this(new InheritanceModelMerger());
    }

    public DefaultInheritanceAssembler(MavenMerger merger) {
        this.merger = merger;
    }

    @Override
    public Model assembleModelInheritance(Model child, Model parent, ModelBuilderRequest request, ModelProblemCollector problems) {
        HashMap<String, String> hints = new HashMap<String, String>();
        String childPath = child.getProperties().getOrDefault(CHILD_DIRECTORY_PROPERTY, child.getArtifactId());
        hints.put(CHILD_DIRECTORY, childPath);
        hints.put("child-path-adjustment", this.getChildPathAdjustment(child, parent, childPath));
        return this.merger.merge(child, parent, false, hints);
    }

    private String getChildPathAdjustment(Model child, Model parent, String childDirectory) {
        String adjustment = "";
        if (parent != null) {
            String childName = child.getArtifactId();
            if (child.getProjectDirectory() != null) {
                childName = child.getProjectDirectory().getFileName().toString();
            }
            for (String module : parent.getModules()) {
                int lastSlash;
                String moduleName;
                if ((module = module.replace('\\', '/')).regionMatches(true, module.length() - 4, ".xml", 0, 4)) {
                    module = module.substring(0, module.lastIndexOf(47) + 1);
                }
                if ((moduleName = module).endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 1);
                }
                if (!(moduleName = moduleName.substring((lastSlash = moduleName.lastIndexOf(47)) + 1)).equals(childName) && !moduleName.equals(childDirectory) || lastSlash < 0) continue;
                adjustment = module.substring(0, lastSlash);
                break;
            }
        }
        return adjustment;
    }

    protected static class InheritanceModelMerger
    extends MavenModelMerger {
        protected InheritanceModelMerger() {
        }

        @Override
        protected String extrapolateChildUrl(String parentUrl, boolean appendPath, Map<Object, Object> context) {
            Object childDirectory = context.get(DefaultInheritanceAssembler.CHILD_DIRECTORY);
            Object childPathAdjustment = context.get("child-path-adjustment");
            if (parentUrl == null || parentUrl.isBlank() || childDirectory == null || childPathAdjustment == null || !appendPath) {
                return parentUrl;
            }
            return this.appendPath(parentUrl, childDirectory.toString(), childPathAdjustment.toString());
        }

        private String appendPath(String parentUrl, String childPath, String pathAdjustment) {
            StringBuilder url = new StringBuilder(parentUrl.length() + pathAdjustment.length() + childPath.length() + (pathAdjustment.isEmpty() ? 1 : 2));
            url.append(parentUrl);
            this.concatPath(url, pathAdjustment);
            this.concatPath(url, childPath);
            return url.toString();
        }

        private void concatPath(StringBuilder url, String path) {
            if (!path.isEmpty()) {
                boolean pathStartsWithSlash;
                boolean initialUrlEndsWithSlash = url.charAt(url.length() - 1) == '/';
                boolean bl = pathStartsWithSlash = path.charAt(0) == '/';
                if (pathStartsWithSlash) {
                    if (initialUrlEndsWithSlash) {
                        url.setLength(url.length() - 1);
                    }
                } else if (!initialUrlEndsWithSlash) {
                    url.append('/');
                }
                url.append(path);
                if (initialUrlEndsWithSlash && !path.endsWith("/")) {
                    url.append('/');
                }
            }
        }

        @Override
        protected void mergeModelBase_Properties(ModelBase.Builder builder, ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
            HashMap<String, String> merged = new HashMap<String, String>();
            if (sourceDominant) {
                merged.putAll(target.getProperties());
                this.putAll(merged, source.getProperties(), DefaultInheritanceAssembler.CHILD_DIRECTORY_PROPERTY);
            } else {
                this.putAll(merged, source.getProperties(), DefaultInheritanceAssembler.CHILD_DIRECTORY_PROPERTY);
                merged.putAll(target.getProperties());
            }
            builder.properties(merged);
            builder.location((Object)"properties", InputLocation.merge((InputLocation)target.getLocation((Object)"properties"), (InputLocation)source.getLocation((Object)"properties"), (boolean)sourceDominant));
        }

        private void putAll(Map<String, String> s, Map<String, String> t, Object excludeKey) {
            for (Map.Entry<String, String> e : t.entrySet()) {
                if (e.getKey().equals(excludeKey)) continue;
                s.put(e.getKey(), e.getValue());
            }
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer.Builder builder, PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                List tgt = target.getPlugins();
                LinkedHashMap master = new LinkedHashMap(src.size() * 2);
                for (Plugin element : src) {
                    if (!element.isInherited() && element.getExecutions().isEmpty()) continue;
                    Object plugin = Plugin.newInstance((boolean)false);
                    plugin = this.mergePlugin((Plugin)plugin, element, sourceDominant, context);
                    Object key = this.getPluginKey().apply((Plugin)plugin);
                    master.put(key, plugin);
                }
                LinkedHashMap predecessors = new LinkedHashMap();
                ArrayList<Plugin> pending = new ArrayList<Plugin>();
                for (Plugin element : tgt) {
                    Object key = this.getPluginKey().apply(element);
                    Plugin existing = (Plugin)master.get(key);
                    if (existing != null) {
                        element = this.mergePlugin(element, existing, sourceDominant, context);
                        master.put(key, element);
                        if (pending.isEmpty()) continue;
                        predecessors.put(key, pending);
                        pending = new ArrayList();
                        continue;
                    }
                    pending.add(element);
                }
                ArrayList<Plugin> result = new ArrayList<Plugin>(src.size() + tgt.size());
                for (Map.Entry entry : master.entrySet()) {
                    List pre = (List)predecessors.get(entry.getKey());
                    if (pre != null) {
                        result.addAll(pre);
                    }
                    result.add((Plugin)entry.getValue());
                }
                result.addAll(pending);
                builder.plugins(result);
            }
        }

        @Override
        protected Plugin mergePlugin(Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            Plugin.Builder builder = Plugin.newBuilder((Plugin)target);
            if (source.isInherited()) {
                this.mergeConfigurationContainer((ConfigurationContainer.Builder)builder, (ConfigurationContainer)target, (ConfigurationContainer)source, sourceDominant, context);
            }
            this.mergePlugin_GroupId(builder, target, source, sourceDominant, context);
            this.mergePlugin_ArtifactId(builder, target, source, sourceDominant, context);
            this.mergePlugin_Version(builder, target, source, sourceDominant, context);
            this.mergePlugin_Extensions(builder, target, source, sourceDominant, context);
            this.mergePlugin_Executions(builder, target, source, sourceDominant, context);
            this.mergePlugin_Dependencies(builder, target, source, sourceDominant, context);
            return builder.build();
        }

        @Override
        protected void mergeReporting_Plugins(Reporting.Builder builder, Reporting target, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List src = source.getPlugins();
            if (!src.isEmpty()) {
                List tgt = target.getPlugins();
                LinkedHashMap merged = new LinkedHashMap((src.size() + tgt.size()) * 2);
                for (ReportPlugin element : src) {
                    if (!element.isInherited()) continue;
                    ReportPlugin plugin = ReportPlugin.newInstance((boolean)false);
                    plugin = this.mergeReportPlugin(plugin, element, sourceDominant, context);
                    merged.put(this.getReportPluginKey().apply(element), plugin);
                }
                for (ReportPlugin element : tgt) {
                    Object key = this.getReportPluginKey().apply(element);
                    ReportPlugin existing = (ReportPlugin)merged.get(key);
                    if (existing != null) {
                        element = this.mergeReportPlugin(element, existing, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                builder.plugins(merged.values());
            }
        }
    }
}

