/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class WeakIdentityMap<K, V>
implements Map<K, V> {
    private final ReferenceQueue<K> keyQueue = new ReferenceQueue();
    private final ReferenceQueue<V> valueQueue = new ReferenceQueue();
    private final ConcurrentHashMap<WeakIdentityReference<K>, ComputeReference<V>> map = new ConcurrentHashMap();

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(mappingFunction);
        while (true) {
            ComputeReference<V> computingRef;
            this.expungeStaleEntries();
            WeakIdentityReference<K> weakKey = new WeakIdentityReference<K>(key, this.keyQueue);
            ComputeReference<V> valueRef = this.map.get(weakKey);
            if (valueRef != null && !valueRef.computing) {
                Object value = valueRef.get();
                if (value != null) {
                    return (V)value;
                }
                this.map.remove(weakKey, valueRef);
            }
            if ((valueRef = this.map.putIfAbsent(weakKey, computingRef = ComputeReference.computing(this.valueQueue))) == null) {
                try {
                    V newValue = mappingFunction.apply(key);
                    if (newValue == null) {
                        this.map.remove(weakKey, computingRef);
                        return null;
                    }
                    ComputeReference<V> newValueRef = new ComputeReference<V>(newValue, this.valueQueue);
                    this.map.replace(weakKey, computingRef, newValueRef);
                    return newValue;
                }
                catch (Throwable t) {
                    this.map.remove(weakKey, computingRef);
                    throw t;
                }
            }
            if (valueRef.computing) continue;
            Object value = valueRef.get();
            if (value != null) {
                return (V)value;
            }
            if (!this.map.remove(weakKey, valueRef)) continue;
        }
    }

    private void expungeStaleEntries() {
        Reference<Object> ref;
        while ((ref = this.keyQueue.poll()) != null) {
            this.map.remove(ref);
        }
        while ((ref = this.valueQueue.poll()) != null) {
            this.map.values().remove(ref);
        }
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        return this.map.containsKey(new WeakIdentityReference<Object>(key, (ReferenceQueue<Object>)null));
    }

    @Override
    public boolean containsValue(Object value) {
        this.expungeStaleEntries();
        for (WeakReference weakReference : this.map.values()) {
            Object v = weakReference.get();
            if (v == null || v != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        this.expungeStaleEntries();
        WeakReference ref = this.map.get(new WeakIdentityReference<Object>(key, (ReferenceQueue<Object>)null));
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.expungeStaleEntries();
        WeakReference oldValueRef = this.map.put(new WeakIdentityReference<K>(key, this.keyQueue), new ComputeReference<V>(value, this.valueQueue));
        return oldValueRef != null ? (V)oldValueRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.expungeStaleEntries();
        WeakReference valueRef = this.map.remove(new WeakIdentityReference<Object>(key, (ReferenceQueue<Object>)null));
        return valueRef != null ? (V)valueRef.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Objects.requireNonNull(m);
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.expungeStaleEntries();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet not supported");
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException("values not supported");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet not supported");
    }

    private static class WeakIdentityReference<T>
    extends WeakReference<T> {
        private final int hash;

        WeakIdentityReference(T referent, ReferenceQueue<T> queue) {
            super(referent, queue);
            this.hash = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakIdentityReference)) {
                return false;
            }
            WeakIdentityReference other = (WeakIdentityReference)obj;
            Object thisRef = this.get();
            Object otherRef = other.get();
            return thisRef != null && thisRef.equals(otherRef);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class ComputeReference<V>
    extends WeakReference<V> {
        private final boolean computing;

        ComputeReference(V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.computing = false;
        }

        private ComputeReference(ReferenceQueue<V> queue) {
            super(null, queue);
            this.computing = true;
        }

        static <V> ComputeReference<V> computing(ReferenceQueue<V> queue) {
            return new ComputeReference<V>(queue);
        }
    }
}

