/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.cache;

import java.util.function.Function;
import org.apache.maven.impl.cache.DefaultRequestCache;

class CachingSupplier<REQ, REP>
implements Function<REQ, REP> {
    final Function<REQ, REP> supplier;
    volatile Object value;

    CachingSupplier(Function<REQ, REP> supplier) {
        this.supplier = supplier;
    }

    Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REP apply(REQ req) {
        Object v = this.value;
        if (v == null) {
            CachingSupplier cachingSupplier = this;
            synchronized (cachingSupplier) {
                v = this.value;
                if (v == null) {
                    try {
                        v = this.value = this.supplier.apply(req);
                    }
                    catch (Exception e) {
                        v = this.value = new AltRes(e);
                    }
                }
            }
        }
        if (v instanceof AltRes) {
            AltRes altRes = (AltRes)v;
            DefaultRequestCache.uncheckedThrow(altRes.t);
        }
        return (REP)v;
    }

    static class AltRes {
        final Throwable t;

        AltRes(Throwable t) {
            this.t = t;
        }
    }
}

