/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.settings.v4.SettingsMerger;

public final class SettingsUtilsV4 {
    private SettingsUtilsV4() {
    }

    public static Settings merge(Settings dominant, Settings recessive) {
        return new SettingsMerger().merge(dominant, recessive, true, Collections.emptyMap());
    }

    public static Profile convertToSettingsProfile(org.apache.maven.api.model.Profile modelProfile) {
        List pluginRepos;
        Profile.Builder profile = Profile.newBuilder();
        profile.id(modelProfile.getId());
        Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            org.apache.maven.api.model.ActivationFile modelFile;
            Object modelOs;
            Activation.Builder activation = org.apache.maven.api.settings.Activation.newBuilder();
            activation.activeByDefault(modelActivation.isActiveByDefault());
            activation.jdk(modelActivation.getJdk());
            ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                org.apache.maven.api.settings.ActivationProperty prop = org.apache.maven.api.settings.ActivationProperty.newBuilder().name(modelProp.getName()).value(modelProp.getValue()).build();
                activation.property(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                ActivationOS os = ActivationOS.newBuilder().arch(modelOs.getArch()).family(modelOs.getFamily()).name(modelOs.getName()).version(modelOs.getVersion()).build();
                activation.os(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                ActivationFile file = ActivationFile.newBuilder().exists(modelFile.getExists()).missing(modelFile.getMissing()).build();
                activation.file(file);
            }
            activation.packaging(modelActivation.getPackaging());
            activation.condition(modelActivation.getCondition());
            profile.activation(activation.build());
        }
        profile.properties(modelProfile.getProperties().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toString(), e -> ((String)e.getValue()).toString())));
        List repos = modelProfile.getRepositories();
        if (repos != null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (org.apache.maven.api.model.Repository repo : repos) {
                repositories.add(SettingsUtilsV4.convertToSettingsRepository(repo));
            }
            profile.repositories(repositories);
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (org.apache.maven.api.model.Repository pluginRepo : pluginRepos) {
                repositories.add(SettingsUtilsV4.convertToSettingsRepository(pluginRepo));
            }
            profile.pluginRepositories(repositories);
        }
        return profile.build();
    }

    public static org.apache.maven.api.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List pluginRepos;
        Profile.Builder profile = org.apache.maven.api.model.Profile.newBuilder();
        profile.id(settingsProfile.getId());
        org.apache.maven.api.settings.Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            ActivationOS settingsOs;
            Activation.Builder activation = Activation.newBuilder();
            activation.activeByDefault(settingsActivation.isActiveByDefault());
            activation.location((Object)"activeByDefault", SettingsUtilsV4.toLocation(settingsActivation.getLocation((Object)"activeByDefault")));
            activation.jdk(settingsActivation.getJdk());
            activation.location((Object)"jdk", SettingsUtilsV4.toLocation(settingsActivation.getLocation((Object)"jdk")));
            org.apache.maven.api.settings.ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                activation.property(ActivationProperty.newBuilder().name(settingsProp.getName()).value(settingsProp.getValue()).location((Object)"name", SettingsUtilsV4.toLocation(settingsProp.getLocation((Object)"name"))).location((Object)"value", SettingsUtilsV4.toLocation(settingsProp.getLocation((Object)"value"))).build());
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                activation.os(org.apache.maven.api.model.ActivationOS.newBuilder().arch(settingsOs.getArch()).family(settingsOs.getFamily()).name(settingsOs.getName()).version(settingsOs.getVersion()).location((Object)"arch", SettingsUtilsV4.toLocation(settingsOs.getLocation((Object)"arch"))).location((Object)"family", SettingsUtilsV4.toLocation(settingsOs.getLocation((Object)"family"))).location((Object)"name", SettingsUtilsV4.toLocation(settingsOs.getLocation((Object)"name"))).location((Object)"version", SettingsUtilsV4.toLocation(settingsOs.getLocation((Object)"version"))).build());
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                activation.file(org.apache.maven.api.model.ActivationFile.newBuilder().exists(settingsFile.getExists()).missing(settingsFile.getMissing()).location((Object)"exists", SettingsUtilsV4.toLocation(settingsFile.getLocation((Object)"exists"))).location((Object)"missing", SettingsUtilsV4.toLocation(settingsFile.getLocation((Object)"missing"))).build());
            }
            activation.packaging(settingsActivation.getPackaging());
            activation.condition(settingsActivation.getCondition());
            profile.activation(activation.build());
        }
        profile.properties(settingsProfile.getProperties());
        profile.location((Object)"properties", SettingsUtilsV4.toLocation(settingsProfile.getLocation((Object)"properties")));
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            profile.repositories((Collection)repos.stream().map(SettingsUtilsV4::convertFromSettingsRepository).collect(Collectors.toList()));
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            profile.pluginRepositories((Collection)pluginRepos.stream().map(SettingsUtilsV4::convertFromSettingsRepository).collect(Collectors.toList()));
        }
        org.apache.maven.api.model.Profile value = profile.build();
        value.setSource("settings.xml");
        return value;
    }

    private static org.apache.maven.api.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        Repository.Builder repo = org.apache.maven.api.model.Repository.newBuilder();
        repo.id(settingsRepo.getId());
        repo.layout(settingsRepo.getLayout());
        repo.name(settingsRepo.getName());
        repo.url(settingsRepo.getUrl());
        repo.location((Object)"id", SettingsUtilsV4.toLocation(settingsRepo.getLocation((Object)"id")));
        repo.location((Object)"layout", SettingsUtilsV4.toLocation(settingsRepo.getLocation((Object)"layout")));
        repo.location((Object)"name", SettingsUtilsV4.toLocation(settingsRepo.getLocation((Object)"name")));
        repo.location((Object)"url", SettingsUtilsV4.toLocation(settingsRepo.getLocation((Object)"url")));
        if (settingsRepo.getSnapshots() != null) {
            repo.snapshots(SettingsUtilsV4.convertRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.releases(SettingsUtilsV4.convertRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo.build();
    }

    private static RepositoryPolicy convertRepositoryPolicy(org.apache.maven.api.settings.RepositoryPolicy settingsPolicy) {
        RepositoryPolicy policy = RepositoryPolicy.newBuilder().enabled(Boolean.toString(settingsPolicy.isEnabled())).updatePolicy(settingsPolicy.getUpdatePolicy()).checksumPolicy(settingsPolicy.getChecksumPolicy()).location((Object)"enabled", SettingsUtilsV4.toLocation(settingsPolicy.getLocation((Object)"enabled"))).location((Object)"updatePolicy", SettingsUtilsV4.toLocation(settingsPolicy.getLocation((Object)"updatePolicy"))).location((Object)"checksumPolicy", SettingsUtilsV4.toLocation(settingsPolicy.getLocation((Object)"checksumPolicy"))).build();
        return policy;
    }

    private static Repository convertToSettingsRepository(org.apache.maven.api.model.Repository modelRepo) {
        Repository repo = Repository.newBuilder().id(modelRepo.getId()).layout(modelRepo.getLayout()).name(modelRepo.getName()).url(modelRepo.getUrl()).snapshots(modelRepo.getSnapshots() != null ? SettingsUtilsV4.convertRepositoryPolicy(modelRepo.getSnapshots()) : null).releases(modelRepo.getReleases() != null ? SettingsUtilsV4.convertRepositoryPolicy(modelRepo.getReleases()) : null).build();
        return repo;
    }

    private static org.apache.maven.api.settings.RepositoryPolicy convertRepositoryPolicy(RepositoryPolicy modelPolicy) {
        org.apache.maven.api.settings.RepositoryPolicy policy = org.apache.maven.api.settings.RepositoryPolicy.newBuilder().enabled(modelPolicy.isEnabled()).updatePolicy(modelPolicy.getUpdatePolicy()).checksumPolicy(modelPolicy.getChecksumPolicy()).build();
        return policy;
    }

    private static org.apache.maven.api.model.InputLocation toLocation(InputLocation location) {
        if (location != null) {
            org.apache.maven.api.settings.InputSource source = location.getSource();
            Map<Object, org.apache.maven.api.model.InputLocation> locs = location.getLocations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SettingsUtilsV4.toLocation((InputLocation)e.getValue())));
            return new org.apache.maven.api.model.InputLocation(location.getLineNumber(), location.getColumnNumber(), source != null ? new InputSource("", source.getLocation()) : null, locs);
        }
        return null;
    }
}

