/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder.execution;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenExecutionRequestPopulator.class)
public class DefaultMavenExecutionRequestPopulator
implements MavenExecutionRequestPopulator {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement(hint="maven")
    private SecDispatcher securityDispatcher;

    @Override
    public MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenEmbedderException {
        String password;
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            server = server.clone();
            password = this.decrypt(server.getPassword(), "password for server " + server.getId());
            server.setPassword(password);
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            proxy = proxy.clone();
            password = this.decrypt(proxy.getPassword(), "password for proxy " + proxy.getId());
            proxy.setPassword(password);
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            mirror = mirror.clone();
            request.addMirror(mirror);
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile((Profile)rawProfile));
        }
        return request;
    }

    private String decrypt(String encrypted, String source) {
        try {
            return this.securityDispatcher.decrypt(encrypted);
        }
        catch (SecDispatcherException e) {
            this.logger.warn("Not decrypting " + source + " due to exception in security handler: " + e.getMessage());
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (cause instanceof FileNotFoundException) {
                this.logger.warn("Ensure that you have configured your master password file (and relocation if appropriate).");
                this.logger.warn("See the installation instructions for details.");
            }
            this.logger.debug("Full stack trace follows", (Throwable)e);
            return encrypted;
        }
    }

    private void pom(MavenExecutionRequest request) {
        if (request.getPom() != null && !request.getPom().isAbsolute()) {
            request.setPom(request.getPom().getAbsoluteFile());
        }
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        } else if (request.getPom() == null && request.getBaseDirectory() != null) {
            File pom = new File(request.getBaseDirectory(), "pom.xml");
            request.setPom(pom);
        } else if (request.getBaseDirectory() == null) {
            request.setBaseDirectory(new File(System.getProperty("user.dir")));
        }
    }

    private void populateDefaultPluginGroups(MavenExecutionRequest request) {
        request.addPluginGroup("org.apache.maven.plugins");
        request.addPluginGroup("org.codehaus.mojo");
    }

    private void injectDefaultRepositories(MavenExecutionRequest request) throws MavenEmbedderException {
        Set<String> definedRepositories = this.getRepoIds(request.getRemoteRepositories());
        if (!definedRepositories.contains("central")) {
            try {
                request.addRemoteRepository(this.repositorySystem.createDefaultRemoteRepository());
            }
            catch (InvalidRepositoryException e) {
                throw new MavenEmbedderException("Cannot create default remote repository.", e);
            }
        }
    }

    private void injectDefaultPluginRepositories(MavenExecutionRequest request) throws MavenEmbedderException {
        Set<String> definedRepositories = this.getRepoIds(request.getPluginArtifactRepositories());
        if (!definedRepositories.contains("central")) {
            try {
                request.addPluginArtifactRepository(this.repositorySystem.createDefaultRemoteRepository());
            }
            catch (InvalidRepositoryException e) {
                throw new MavenEmbedderException("Cannot create default remote repository.", e);
            }
        }
    }

    private Set<String> getRepoIds(List<ArtifactRepository> repositories) {
        HashSet<String> repoIds = new HashSet<String>();
        if (repositories != null) {
            for (ArtifactRepository repository : repositories) {
                repoIds.add(repository.getId());
            }
        }
        return repoIds;
    }

    private void processRepositoriesInSettings(MavenExecutionRequest request) throws MavenEmbedderException {
        this.repositorySystem.injectMirror(request.getRemoteRepositories(), request.getMirrors());
        this.repositorySystem.injectProxy(request.getRemoteRepositories(), request.getProxies());
        this.repositorySystem.injectAuthentication(request.getRemoteRepositories(), request.getServers());
        request.setRemoteRepositories(this.repositorySystem.getEffectiveRepositories(request.getRemoteRepositories()));
        this.repositorySystem.injectMirror(request.getPluginArtifactRepositories(), request.getMirrors());
        this.repositorySystem.injectProxy(request.getPluginArtifactRepositories(), request.getProxies());
        this.repositorySystem.injectAuthentication(request.getPluginArtifactRepositories(), request.getServers());
        request.setPluginArtifactRepositories(this.repositorySystem.getEffectiveRepositories(request.getPluginArtifactRepositories()));
    }

    private void localRepository(MavenExecutionRequest request) throws MavenEmbedderException {
        if (request.getLocalRepository() == null) {
            request.setLocalRepository(this.createLocalRepository(request));
        }
        if (request.getLocalRepositoryPath() == null) {
            request.setLocalRepositoryPath(new File(request.getLocalRepository().getBasedir()).getAbsoluteFile());
        }
    }

    public ArtifactRepository createLocalRepository(MavenExecutionRequest request) throws MavenEmbedderException {
        String localRepositoryPath = null;
        if (request.getLocalRepositoryPath() != null) {
            localRepositoryPath = request.getLocalRepositoryPath().getAbsolutePath();
        }
        if (StringUtils.isEmpty(localRepositoryPath)) {
            localRepositoryPath = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        try {
            return this.repositorySystem.createLocalRepository(new File(localRepositoryPath));
        }
        catch (InvalidRepositoryException e) {
            throw new MavenEmbedderException("Cannot create local repository.", e);
        }
    }

    @Override
    public MavenExecutionRequest populateDefaults(MavenExecutionRequest request) throws MavenEmbedderException {
        this.pom(request);
        this.localRepository(request);
        this.populateDefaultPluginGroups(request);
        this.injectDefaultRepositories(request);
        this.injectDefaultPluginRepositories(request);
        this.processRepositoriesInSettings(request);
        return request;
    }
}

