/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.Maven;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfigurationValidationResult;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.embedder.MavenEmbedderLoggerManager;
import org.apache.maven.embedder.MavenEmbedderSecurityManager;
import org.apache.maven.embedder.PlexusLoggerAdapter;
import org.apache.maven.embedder.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsConfigurationException;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.settings.validation.DefaultSettingsValidator;
import org.apache.maven.settings.validation.SettingsValidationResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenEmbedder {
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    public static final File DEFAULT_USER_TOOLCHAINS_FILE = new File(userMavenConfigurationHome, "toolchains.xml");
    private MutablePlexusContainer container;
    private Maven maven;
    private ProjectBuilder projectBuilder;
    private ModelReader modelReader;
    private ModelWriter modelWriter;
    private MavenExecutionRequestPopulator populator;
    private ClassWorld classWorld;
    private MavenEmbedderLogger logger;
    private boolean activateSystemManager;
    private Configuration configuration;

    public MavenEmbedder(Configuration embedderConfiguration) throws MavenEmbedderException {
        this.start(embedderConfiguration);
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public MavenEmbedderLogger getLogger() {
        return this.logger;
    }

    public void setLogger(MavenEmbedderLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model readModel(File file) throws XmlPullParserException, IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);
        try {
            Model model = this.readModel((Reader)reader);
            return model;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public Model readModel(Reader reader) throws XmlPullParserException, IOException {
        return this.modelReader.read(reader, null);
    }

    public void writeModel(Writer writer, Model model, boolean namespaceDeclaration) throws IOException {
        this.modelWriter.write(writer, null, model);
    }

    public void writeModel(Writer writer, Model model) throws IOException {
        this.modelWriter.write(writer, null, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSettings(File file, Settings settings) throws IOException {
        DefaultSettingsValidator settingsValidator = new DefaultSettingsValidator();
        SettingsValidationResult validationResult = settingsValidator.validate(settings);
        if (validationResult.getMessageCount() > 0) {
            throw new IOException("Failed to validate Settings.\n" + validationResult.render("\n"));
        }
        SettingsXpp3Writer writer = new SettingsXpp3Writer();
        XmlStreamWriter fileWriter = WriterFactory.newXmlWriter((File)file);
        try {
            writer.write((Writer)fileWriter, settings);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    public static Settings readSettings(File file) throws IOException, SettingsConfigurationException {
        XmlStreamReader fileReader = ReaderFactory.newXmlReader((File)file);
        DefaultSettingsValidator settingsValidator = new DefaultSettingsValidator();
        SettingsXpp3Reader reader = new SettingsXpp3Reader();
        try {
            Settings settings = reader.read((Reader)fileReader);
            SettingsValidationResult validationResult = settingsValidator.validate(settings);
            if (validationResult.getMessageCount() > 0) {
                throw new IOException("Failed to validate Settings.\n" + validationResult.render("\n"));
            }
            Settings settings2 = settings;
            return settings2;
        }
        catch (XmlPullParserException e) {
            throw new SettingsConfigurationException("Failed to parse settings.", (Throwable)e);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
    }

    private void start(Configuration configuration) throws MavenEmbedderException {
        this.classWorld = configuration.getClassWorld();
        this.logger = configuration.getMavenEmbedderLogger();
        try {
            if (System.getSecurityManager() == null && this.activateSystemManager) {
                System.setSecurityManager(new MavenEmbedderSecurityManager());
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("Error trying to set the SecurityManager: " + e.getMessage());
        }
        this.configuration = configuration;
        try {
            ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(this.classWorld).setName("embedder");
            this.container = new DefaultPlexusContainer(cc);
        }
        catch (PlexusContainerException e) {
            throw new MavenEmbedderException("Error creating Plexus container for Maven Embedder", e);
        }
        if (this.logger != null) {
            MavenEmbedderLoggerManager loggerManager = new MavenEmbedderLoggerManager(new PlexusLoggerAdapter(this.logger));
            this.container.setLoggerManager((LoggerManager)loggerManager);
        }
        try {
            if (configuration.getContainerCustomizer() != null) {
                configuration.getContainerCustomizer().customize((PlexusContainer)this.container);
            }
            this.modelReader = (ModelReader)this.container.lookup(ModelReader.class);
            this.modelWriter = (ModelWriter)this.container.lookup(ModelWriter.class);
            this.maven = (Maven)this.container.lookup(Maven.class);
            this.projectBuilder = (ProjectBuilder)this.container.lookup(ProjectBuilder.class);
            this.populator = (MavenExecutionRequestPopulator)this.container.lookup(MavenExecutionRequestPopulator.class);
            this.container.lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException("Cannot lookup required component.", e);
        }
    }

    public void stop() throws MavenEmbedderException {
        this.container.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationValidationResult validateConfiguration(Configuration configuration) {
        DefaultConfigurationValidationResult result = new DefaultConfigurationValidationResult();
        XmlStreamReader fileReader = null;
        if (configuration.getUserSettingsFile() != null) {
            try {
                fileReader = ReaderFactory.newXmlReader((File)configuration.getUserSettingsFile());
                result.setUserSettings(new SettingsXpp3Reader().read((Reader)fileReader));
            }
            catch (IOException e) {
                result.setUserSettingsException(e);
            }
            catch (XmlPullParserException e) {
                result.setUserSettingsException((Exception)((Object)e));
            }
            finally {
                IOUtil.close((Reader)fileReader);
            }
        }
        if (configuration.getGlobalSettingsFile() != null) {
            try {
                fileReader = ReaderFactory.newXmlReader((File)configuration.getGlobalSettingsFile());
                result.setGlobalSettings(new SettingsXpp3Reader().read((Reader)fileReader));
            }
            catch (IOException e) {
                result.setGlobalSettingsException(e);
            }
            catch (XmlPullParserException e) {
                result.setGlobalSettingsException((Exception)((Object)e));
            }
            finally {
                IOUtil.close((Reader)fileReader);
            }
        }
        return result;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        LoggerManager loggerManager = this.container.getLoggerManager();
        int oldThreshold = loggerManager.getThreshold();
        try {
            loggerManager.setThresholds(request.getLoggingLevel());
            try {
                request = this.populator.populateDefaults(request);
            }
            catch (MavenEmbedderException e) {
                DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
                result.addException((Throwable)e);
                DefaultMavenExecutionResult defaultMavenExecutionResult = result;
                loggerManager.setThresholds(oldThreshold);
                return defaultMavenExecutionResult;
            }
            MavenExecutionResult mavenExecutionResult = this.maven.execute(request);
            return mavenExecutionResult;
        }
        finally {
            loggerManager.setThresholds(oldThreshold);
        }
    }

    public PlexusContainer getPlexusContainer() {
        return this.container;
    }
}

