/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CLIRequestUtils;
import org.apache.maven.cli.ExecutionEventLogger;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderFileLogger;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.embedder.execution.MavenExecutionRequestPopulator;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";

    public static void main(String[] args) {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        int result = MavenCli.main(args, classWorld);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(args, classWorld);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doMain(String[] args, ClassWorld classWorld) {
        Settings settings;
        MavenEmbedder mavenEmbedder;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp();
            return 1;
        }
        boolean debug = commandLine.hasOption('X');
        boolean quiet = !debug && commandLine.hasOption('q');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (commandLine.hasOption('h')) {
            cliManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            CLIReportingUtils.showVersion();
            return 0;
        }
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
        Configuration configuration = this.buildEmbedderConfiguration(commandLine, classWorld);
        MavenEmbedderLogger logger = configuration.getMavenEmbedderLogger();
        try {
            mavenEmbedder = new MavenEmbedder(configuration);
        }
        catch (MavenEmbedderException e) {
            CLIReportingUtils.showError(logger, "Unable to start the embedder: ", e, showErrors);
            return 1;
        }
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setGlobalSettingsFile(configuration.getGlobalSettingsFile());
        request.setUserSettingsFile(configuration.getUserSettingsFile());
        CLIRequestUtils.populateProperties((MavenExecutionRequest)request, commandLine);
        try {
            MavenSettingsBuilder settingsBuilder = (MavenSettingsBuilder)mavenEmbedder.getPlexusContainer().lookup(MavenSettingsBuilder.class);
            try {
                settings = settingsBuilder.buildSettings((MavenExecutionRequest)request);
            }
            finally {
                try {
                    mavenEmbedder.getPlexusContainer().release((Object)settingsBuilder);
                }
                catch (ComponentLifecycleException e) {
                    logger.debug("Failed to release component: " + e.getMessage(), e);
                }
            }
        }
        catch (ComponentLookupException e) {
            CLIReportingUtils.showError(logger, "Unable to lookup settings builder: ", (Exception)((Object)e), showErrors);
            return 1;
        }
        catch (IOException e) {
            CLIReportingUtils.showError(logger, "Failed to read settings: ", e, showErrors);
            return 1;
        }
        catch (XmlPullParserException e) {
            CLIReportingUtils.showError(logger, "Failed to parse settings: ", (Exception)((Object)e), showErrors);
            return 1;
        }
        try {
            MavenExecutionRequestPopulator requestPopulator = (MavenExecutionRequestPopulator)mavenEmbedder.getPlexusContainer().lookup(MavenExecutionRequestPopulator.class);
            try {
                requestPopulator.populateFromSettings((MavenExecutionRequest)request, settings);
            }
            finally {
                try {
                    mavenEmbedder.getPlexusContainer().release((Object)requestPopulator);
                }
                catch (ComponentLifecycleException e) {
                    logger.debug("Failed to release component: " + e.getMessage(), e);
                }
            }
        }
        catch (ComponentLookupException e) {
            CLIReportingUtils.showError(logger, "Unable to lookup execution request populator: ", (Exception)((Object)e), showErrors);
            return 1;
        }
        catch (MavenEmbedderException e) {
            CLIReportingUtils.showError(logger, "Failed to process settings: ", e, showErrors);
            return 1;
        }
        CLIRequestUtils.populateRequest((MavenExecutionRequest)request, commandLine, debug, quiet, showErrors);
        request.setExecutionListener((ExecutionListener)new ExecutionEventLogger(logger));
        if (debug || commandLine.hasOption('V')) {
            CLIReportingUtils.showVersion();
        }
        if (showErrors) {
            logger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(request.getGlobalChecksumPolicy())) {
            logger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(request.getGlobalChecksumPolicy())) {
            logger.info("Enabling strict checksum verification on all artifact downloads.");
        }
        ConfigurationValidationResult cvr = MavenEmbedder.validateConfiguration(configuration);
        if (cvr.isUserSettingsFilePresent() && !cvr.isUserSettingsFileParses()) {
            CLIReportingUtils.showError(logger, "Error reading user settings: ", cvr.getUserSettingsException(), showErrors);
            return 1;
        }
        if (cvr.isGlobalSettingsFilePresent() && !cvr.isGlobalSettingsFileParses()) {
            CLIReportingUtils.showError(logger, "Error reading global settings: ", cvr.getGlobalSettingsException(), showErrors);
            return 1;
        }
        if (configuration.getGlobalSettingsFile() != null) {
            request.setGlobalSettingsFile(configuration.getGlobalSettingsFile());
        }
        if (configuration.getUserSettingsFile() != null) {
            request.setUserSettingsFile(configuration.getUserSettingsFile());
        }
        try {
            String passwd;
            if (commandLine.hasOption("emp")) {
                passwd = commandLine.getOptionValue("emp");
                DefaultPlexusCipher cipher = new DefaultPlexusCipher();
                System.out.println(cipher.encryptAndDecorate(passwd, "settings.security"));
                return 0;
            }
            if (commandLine.hasOption("ep")) {
                passwd = commandLine.getOptionValue("ep");
                DefaultSecDispatcher dispatcher = (DefaultSecDispatcher)mavenEmbedder.getPlexusContainer().lookup(SecDispatcher.class);
                String configurationFile = dispatcher.getConfigurationFile();
                if (configurationFile.startsWith("~")) {
                    configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
                }
                String file = System.getProperty("settings.security", configurationFile);
                mavenEmbedder.getPlexusContainer().release((Object)dispatcher);
                String master = null;
                SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
                if (sec != null) {
                    master = sec.getMaster();
                }
                if (master == null) {
                    System.err.println("Master password is not set in the setting security file");
                    return 1;
                }
                DefaultPlexusCipher cipher = new DefaultPlexusCipher();
                String masterPasswd = cipher.decryptDecorated(master, "settings.security");
                System.out.println(cipher.encryptAndDecorate(passwd, masterPasswd));
                return 0;
            }
        }
        catch (Exception e) {
            System.err.println("FATAL ERROR: Error encrypting password: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
        MavenExecutionResult result = mavenEmbedder.execute((MavenExecutionRequest)request);
        try {
            mavenEmbedder.stop();
        }
        catch (MavenEmbedderException e) {
            result.addException((Throwable)e);
        }
        if (result.hasExceptions()) {
            ExceptionSummary es = result.getExceptionSummary();
            if (es == null) {
                logger.error("", (Throwable)result.getExceptions().get(0));
            } else if (showErrors) {
                logger.error(es.getMessage(), es.getException());
            } else {
                logger.error(es.getMessage());
            }
            if ("FAIL_NEVER".equals(request.getReactorFailureBehavior())) {
                logger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private Configuration buildEmbedderConfiguration(CommandLine commandLine, ClassWorld classWorld) {
        File userSettingsFile = commandLine.hasOption('s') ? new File(commandLine.getOptionValue('s')) : MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        File globalSettingsFile = commandLine.hasOption("gs") ? new File(commandLine.getOptionValue("gs")) : MavenEmbedder.DEFAULT_GLOBAL_SETTINGS_FILE;
        Configuration configuration = new DefaultConfiguration().setUserSettingsFile(userSettingsFile).setGlobalSettingsFile(globalSettingsFile).setClassWorld(classWorld);
        if (commandLine.hasOption("l")) {
            File logFile = new File(commandLine.getOptionValue("l")).getAbsoluteFile();
            configuration.setMavenEmbedderLogger(new MavenEmbedderFileLogger(logFile));
        } else {
            configuration.setMavenEmbedderLogger(new MavenEmbedderConsoleLogger());
        }
        return configuration;
    }
}

