/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.maven.cli.AbstractConsoleDownloadMonitor;
import org.apache.maven.cli.BatchModeDownloadMonitor;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

final class CLIRequestUtils {
    private CLIRequestUtils() {
    }

    public static void populateProperties(MavenExecutionRequest request, CommandLine commandLine) {
        Properties systemProperties = new Properties();
        Properties userProperties = new Properties();
        CLIRequestUtils.populateProperties(commandLine, systemProperties, userProperties);
        request.setUserProperties(userProperties);
        request.setSystemProperties(systemProperties);
    }

    public static MavenExecutionRequest populateRequest(MavenExecutionRequest request, CommandLine commandLine, boolean debug, boolean quiet, boolean showErrors) {
        String[] profileOptionValues;
        if (commandLine.hasOption('B')) {
            request.setInteractiveMode(false);
        }
        boolean pluginUpdateOverride = false;
        if (commandLine.hasOption("cpu") || commandLine.hasOption("up")) {
            pluginUpdateOverride = true;
        } else if (commandLine.hasOption("npu")) {
            pluginUpdateOverride = false;
        }
        boolean noSnapshotUpdates = false;
        if (commandLine.hasOption("nsu")) {
            noSnapshotUpdates = true;
        }
        List goals = commandLine.getArgList();
        boolean recursive = true;
        String reactorFailureBehaviour = "FAIL_FAST";
        if (commandLine.hasOption('N')) {
            recursive = false;
        }
        if (commandLine.hasOption("ff")) {
            reactorFailureBehaviour = "FAIL_FAST";
        } else if (commandLine.hasOption("fae")) {
            reactorFailureBehaviour = "FAIL_AT_END";
        } else if (commandLine.hasOption("fn")) {
            reactorFailureBehaviour = "FAIL_NEVER";
        }
        if (commandLine.hasOption('o')) {
            request.setOffline(true);
        }
        boolean updateSnapshots = false;
        if (commandLine.hasOption('U')) {
            updateSnapshots = true;
        }
        String globalChecksumPolicy = null;
        if (commandLine.hasOption('C')) {
            globalChecksumPolicy = "fail";
        } else if (commandLine.hasOption('c')) {
            globalChecksumPolicy = "warn";
        }
        File baseDirectory = new File(System.getProperty("user.dir"));
        ArrayList<String> activeProfiles = new ArrayList<String>();
        ArrayList<String> inactiveProfiles = new ArrayList<String>();
        if (commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            for (int i = 0; i < profileOptionValues.length; ++i) {
                StringTokenizer profileTokens = new StringTokenizer(profileOptionValues[i], ",");
                while (profileTokens.hasMoreTokens()) {
                    String profileAction = profileTokens.nextToken().trim();
                    if (profileAction.startsWith("-") || profileAction.startsWith("!")) {
                        inactiveProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    if (profileAction.startsWith("+")) {
                        activeProfiles.add(profileAction.substring(1));
                        continue;
                    }
                    activeProfiles.add(profileAction);
                }
            }
        }
        AbstractConsoleDownloadMonitor transferListener = request.isInteractiveMode() ? new ConsoleDownloadMonitor() : new BatchModeDownloadMonitor();
        transferListener.setShowChecksumEvents(false);
        String alternatePomFile = null;
        if (commandLine.hasOption('f')) {
            alternatePomFile = commandLine.getOptionValue('f');
        }
        int loggingLevel = debug ? 0 : (quiet ? 3 : 1);
        Properties systemProperties = new Properties();
        Properties userProperties = new Properties();
        CLIRequestUtils.populateProperties(commandLine, systemProperties, userProperties);
        File userToolchainsFile = commandLine.hasOption('t') ? new File(commandLine.getOptionValue('t')) : MavenEmbedder.DEFAULT_USER_TOOLCHAINS_FILE;
        request.setBaseDirectory(baseDirectory).setGoals(goals).setSystemProperties(systemProperties).setUserProperties(userProperties).setReactorFailureBehavior(reactorFailureBehaviour).setRecursive(recursive).setShowErrors(showErrors).setUsePluginUpdateOverride(pluginUpdateOverride).addActiveProfiles(activeProfiles).addInactiveProfiles(inactiveProfiles).setLoggingLevel(loggingLevel).setTransferListener((TransferListener)transferListener).setUpdateSnapshots(updateSnapshots).setNoSnapshotUpdates(noSnapshotUpdates).setGlobalChecksumPolicy(globalChecksumPolicy).setUserToolchainsFile(userToolchainsFile);
        File pom = alternatePomFile != null ? new File(alternatePomFile) : new File(baseDirectory, "pom.xml");
        if (pom.exists()) {
            request.setPom(pom);
        }
        if (commandLine.hasOption("rf")) {
            request.setResumeFrom(commandLine.getOptionValue("rf"));
        }
        if (commandLine.hasOption("pl")) {
            String projectList = commandLine.getOptionValue("pl");
            String[] projects = StringUtils.split((String)projectList, (String)",");
            request.setSelectedProjects(Arrays.asList(projects));
        }
        if (commandLine.hasOption("am") && !commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-upstream");
        } else if (!commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-downstream");
        } else if (commandLine.hasOption("am") && commandLine.hasOption("amd")) {
            request.setMakeBehavior("make-both");
        }
        String localRepoProperty = request.getUserProperties().getProperty("maven.repo.local");
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty("maven.repo.local");
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
        return request;
    }

    static void populateProperties(CommandLine commandLine, Properties systemProperties, Properties userProperties) {
        String[] defStrs;
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> e : envVars.entrySet()) {
                systemProperties.setProperty("env." + e.getKey().toString(), e.getValue().toString());
            }
        }
        catch (IOException e) {
            System.err.println("Error getting environment vars for profile activation: " + e);
        }
        if (commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            for (int i = 0; i < defStrs.length; ++i) {
                CLIRequestUtils.setCliProperty(defStrs[i], userProperties);
            }
        }
        systemProperties.putAll((Map<?, ?>)System.getProperties());
    }

    private static void setCliProperty(String property, Properties properties) {
        String value;
        String name;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1).trim();
        }
        properties.setProperty(name, value);
        System.setProperty(name, value);
    }
}

