/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.resolver.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactTransformationManager.class)
public class DefaultArtifactTransformationManager
implements ArtifactTransformationManager {
    @Requirement(role=ArtifactTransformation.class, hints={"release", "latest", "snapshot"})
    private List<ArtifactTransformation> artifactTransformations;

    @Override
    public void transformForResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForResolve(artifact, remoteRepositories, localRepository);
        }
    }

    @Override
    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForInstall(artifact, localRepository);
        }
    }

    @Override
    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        for (ArtifactTransformation transform : this.artifactTransformations) {
            transform.transformForDeployment(artifact, remoteRepository, localRepository);
        }
    }

    @Override
    public List getArtifactTransformations() {
        return this.artifactTransformations;
    }
}

