/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.LocalArtifactRepository;

public class DelegatingLocalArtifactRepository
extends MavenArtifactRepository {
    private LocalArtifactRepository buildReactor;
    private LocalArtifactRepository ideWorkspace;
    private ArtifactRepository userLocalArtifactRepository;

    public DelegatingLocalArtifactRepository(ArtifactRepository artifactRepository) {
        this.userLocalArtifactRepository = artifactRepository;
    }

    public void setBuildReactor(LocalArtifactRepository localRepository) {
        this.buildReactor = localRepository;
    }

    public void setIdeWorkspace(LocalArtifactRepository localRepository) {
        this.ideWorkspace = localRepository;
    }

    public LocalArtifactRepository getIdeWorspace() {
        return this.ideWorkspace;
    }

    public Artifact find(Artifact artifact) {
        if (!artifact.isRelease() && this.buildReactor != null) {
            artifact = this.buildReactor.find(artifact);
        }
        if (!artifact.isResolved() && this.ideWorkspace != null) {
            artifact = this.ideWorkspace.find(artifact);
        }
        if (!artifact.isResolved()) {
            artifact = this.userLocalArtifactRepository.find(artifact);
        }
        return artifact;
    }

    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.userLocalArtifactRepository.pathOfLocalRepositoryMetadata(metadata, this.userLocalArtifactRepository);
    }

    public String getId() {
        return this.userLocalArtifactRepository.getId();
    }

    public String pathOf(Artifact artifact) {
        return this.userLocalArtifactRepository.pathOf(artifact);
    }

    public String getBasedir() {
        return this.userLocalArtifactRepository.getBasedir();
    }

    public ArtifactRepositoryLayout getLayout() {
        return this.userLocalArtifactRepository.getLayout();
    }

    public ArtifactRepositoryPolicy getReleases() {
        return this.userLocalArtifactRepository.getReleases();
    }

    public ArtifactRepositoryPolicy getSnapshots() {
        return this.userLocalArtifactRepository.getSnapshots();
    }

    public String getKey() {
        return this.userLocalArtifactRepository.getKey();
    }

    public String getUrl() {
        return this.userLocalArtifactRepository.getUrl();
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.buildReactor == null ? 0 : this.buildReactor.hashCode());
        hash = hash * 31 + (this.ideWorkspace == null ? 0 : this.ideWorkspace.hashCode());
        hash = hash * 31 + (this.userLocalArtifactRepository == null ? 0 : this.userLocalArtifactRepository.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DelegatingLocalArtifactRepository other = (DelegatingLocalArtifactRepository)obj;
        return DelegatingLocalArtifactRepository.eq(this.buildReactor, other.buildReactor) && DelegatingLocalArtifactRepository.eq(this.ideWorkspace, other.ideWorkspace) && DelegatingLocalArtifactRepository.eq(this.userLocalArtifactRepository, other.userLocalArtifactRepository);
    }
}

