/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.repository.MirrorBuilder;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MirrorBuilder.class)
public class DefaultMirrorBuilder
implements MirrorBuilder {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private static int anonymousMirrorIdSeed = 0;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactRepositoryFactory repositoryFactory;
    private Map<String, ArtifactRepository> mirrors = new LinkedHashMap<String, ArtifactRepository>();

    @Override
    public void addMirror(String id, String mirrorOf, String url) {
        if (id == null) {
            id = "mirror-" + anonymousMirrorIdSeed++;
            this.logger.warn("You are using a mirror that doesn't declare an <id/> element. Using '" + id + "' instead:\nId: " + id + "\nmirrorOf: " + mirrorOf + "\nurl: " + url + "\n");
        }
        ArtifactRepository mirror = this.repositoryFactory.createArtifactRepository(id, url, (ArtifactRepositoryLayout)null, null, null);
        if (!this.mirrors.containsKey(mirrorOf)) {
            this.mirrors.put(mirrorOf, mirror);
        }
    }

    @Override
    public ArtifactRepository getMirror(ArtifactRepository originalRepository) {
        Set<String> keySet;
        ArtifactRepository selectedMirror = this.mirrors.get(originalRepository.getId());
        if (null == selectedMirror && (keySet = this.mirrors.keySet()) != null) {
            for (String pattern : keySet) {
                if (!this.matchPattern(originalRepository, pattern)) continue;
                selectedMirror = this.mirrors.get(pattern);
                break;
            }
        }
        return selectedMirror;
    }

    @Override
    public void clearMirrors() {
        this.mirrors.clear();
        anonymousMirrorIdSeed = 0;
    }

    @Override
    public List<ArtifactRepository> getMirrors(List<ArtifactRepository> remoteRepositories) {
        if (remoteRepositories != null) {
            for (ArtifactRepository repository : remoteRepositories) {
                ArtifactRepository mirror = this.getMirror(repository);
                if (mirror == null) continue;
                repository.setUrl(mirror.getUrl());
                repository.setId(mirror.getId());
            }
        }
        return remoteRepositories;
    }

    ArtifactRepository getMirrorRepository(ArtifactRepository repository) {
        ArtifactRepository mirror = this.getMirror(repository);
        if (mirror != null) {
            String id = mirror.getId();
            if (id == null) {
                id = repository.getId();
            }
            this.logger.debug("Using mirror: " + mirror.getId() + " for repository: " + repository.getId() + "\n(mirror url: " + mirror.getUrl() + ")");
            repository = this.repositoryFactory.createArtifactRepository(id, mirror.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
        }
        return repository;
    }

    boolean matchPattern(ArtifactRepository originalRepository, String pattern) {
        boolean result = false;
        String originalId = originalRepository.getId();
        if (WILDCARD.equals(pattern) || pattern.equals(originalId)) {
            result = true;
        } else {
            String[] repos;
            for (String repo : repos = pattern.split(",")) {
                if (repo.length() > 1 && repo.startsWith("!")) {
                    if (!originalId.equals(repo.substring(1))) continue;
                    result = false;
                    break;
                }
                if (originalId.equals(repo)) {
                    result = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(repo) && this.isExternalRepo(originalRepository)) {
                    result = true;
                    continue;
                }
                if (!WILDCARD.equals(repo)) continue;
                result = true;
            }
        }
        return result;
    }

    boolean isExternalRepo(ArtifactRepository originalRepository) {
        try {
            URL url = new URL(originalRepository.getUrl());
            return !url.getHost().equals("localhost") && !url.getHost().equals("127.0.0.1") && !url.getProtocol().equals("file");
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

