/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Repository;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectUtils {
    static RepositorySystem rs;

    private ProjectUtils() {
    }

    public static List<ArtifactRepository> buildArtifactRepositories(List<Repository> repositories, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer c) throws InvalidRepositoryException {
        List<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>();
        for (Repository r : repositories) {
            remoteRepositories.add(ProjectUtils.buildArtifactRepository(r, artifactRepositoryFactory, c));
        }
        remoteRepositories = ProjectUtils.rs(c).getMirrors(remoteRepositories);
        return remoteRepositories;
    }

    public static ArtifactRepository buildDeploymentArtifactRepository(DeploymentRepository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer c) throws InvalidRepositoryException {
        return ProjectUtils.rs(c).buildArtifactRepository((Repository)repo);
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo, ArtifactRepositoryFactory artifactRepositoryFactory, PlexusContainer c) throws InvalidRepositoryException {
        return ProjectUtils.rs(c).buildArtifactRepository(repo);
    }

    private static RepositorySystem rs(PlexusContainer c) {
        try {
            rs = (RepositorySystem)c.lookup(RepositorySystem.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return rs;
    }
}

