/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.profiles.ProfileActivationContext;
import org.apache.maven.profiles.ProfileActivationException;
import org.apache.maven.profiles.ProfileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DefaultProfileManager
implements ProfileManager {
    private Map<String, Profile> profilesById = new LinkedHashMap<String, Profile>();
    private ProfileActivationContext profileActivationContext;
    private static final List<ProfileActivator> activators = Arrays.asList(new PropertyProfileActivator(), new OperatingSystemProfileActivator(), new FileProfileActivator(), new JdkVersionProfileActivator());

    public DefaultProfileManager(ProfileActivationContext profileActivationContext) {
        this.profileActivationContext = profileActivationContext == null ? this.createDefaultActivationContext() : profileActivationContext;
    }

    private ProfileActivationContext createDefaultActivationContext() {
        return new ProfileActivationContext(System.getProperties(), false);
    }

    @Override
    public ProfileActivationContext getProfileActivationContext() {
        return this.profileActivationContext;
    }

    @Override
    public void setProfileActivationContext(ProfileActivationContext profileActivationContext) {
        this.profileActivationContext = profileActivationContext;
    }

    @Override
    public Map<String, Profile> getProfilesById() {
        return this.profilesById;
    }

    @Override
    public void addProfile(Profile profile) {
        String profileId = profile.getId();
        Profile existing = this.profilesById.get(profileId);
        if (existing != null) {
            System.out.println("Overriding profile: '" + profileId + "' (source: " + existing.getSource() + ") with new instance from source: " + profile.getSource());
        }
        this.profilesById.put(profile.getId(), profile);
        Activation activation = profile.getActivation();
        if (activation != null && activation.isActiveByDefault()) {
            this.activateAsDefault(profileId);
        }
    }

    @Override
    public List<Profile> getActiveProfiles() throws ProfileActivationException {
        return this.getActiveProfiles(null);
    }

    @Override
    public List<Profile> getActiveProfiles(Model model) throws ProfileActivationException {
        ArrayList<Profile> activeFromPom = new ArrayList<Profile>();
        ArrayList<Profile> activeExternal = new ArrayList<Profile>();
        for (Map.Entry<String, Profile> entry : this.profilesById.entrySet()) {
            String profileId = entry.getKey();
            Profile profile = entry.getValue();
            if (this.profileActivationContext.isExplicitlyInactive(profileId) || !this.profileActivationContext.isExplicitlyActive(profileId) && !this.isActive(profile, this.profileActivationContext)) continue;
            if ("pom".equals(profile.getSource())) {
                activeFromPom.add(profile);
                continue;
            }
            activeExternal.add(profile);
        }
        if (activeFromPom.isEmpty()) {
            List<String> defaultIds = this.profileActivationContext.getActiveByDefaultProfileIds();
            List<String> deactivatedIds = this.profileActivationContext.getExplicitlyInactiveProfileIds();
            for (String profileId : defaultIds) {
                Profile profile;
                if (deactivatedIds.contains(profileId) || (profile = this.profilesById.get(profileId)) == null) continue;
                activeFromPom.add(profile);
            }
        }
        ArrayList<Profile> allActive = new ArrayList<Profile>(activeFromPom.size() + activeExternal.size());
        allActive.addAll(activeExternal);
        allActive.addAll(activeFromPom);
        List<Profile> defaults = DefaultProfileManager.getDefaultProfiles(allActive);
        if (defaults.size() < allActive.size()) {
            allActive.removeAll(defaults);
        }
        return allActive;
    }

    @Override
    public void addProfiles(List<Profile> profiles) {
        for (Profile profile : profiles) {
            this.addProfile(profile);
        }
    }

    private static List<Profile> getDefaultProfiles(List<Profile> profiles) {
        ArrayList<Profile> defaults = new ArrayList<Profile>();
        for (Profile p : profiles) {
            if (p.getActivation() == null || !p.getActivation().isActiveByDefault()) continue;
            defaults.add(p);
        }
        return defaults;
    }

    private boolean isActive(Profile profile, ProfileActivationContext context) throws ProfileActivationException {
        for (ProfileActivator activator : activators) {
            try {
                if (!activator.isActive(profile, (org.apache.maven.model.profile.ProfileActivationContext)context)) continue;
                return true;
            }
            catch (org.apache.maven.model.profile.ProfileActivationException e) {
                throw new ProfileActivationException(e.getMessage(), e.getCause());
            }
        }
        return false;
    }

    private void activateAsDefault(String profileId) {
        List<String> defaultIds = this.profileActivationContext.getActiveByDefaultProfileIds();
        if (!defaultIds.contains(profileId)) {
            this.profileActivationContext.setActiveByDefault(profileId);
        }
    }
}

