/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class ScopeArtifactFilter
implements ArtifactFilter {
    private final boolean compileScope;
    private final boolean runtimeScope;
    private final boolean testScope;
    private final boolean providedScope;
    private final boolean systemScope;
    private final String scope;

    public ScopeArtifactFilter(String scope) {
        this.scope = scope;
        if (Artifact.SCOPE_COMPILE.equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = false;
            this.testScope = false;
        } else if (Artifact.SCOPE_RUNTIME.equals(scope)) {
            this.systemScope = false;
            this.providedScope = false;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = false;
        } else if (Artifact.SCOPE_RUNTIME_PLUS_SYSTEM.equals(scope)) {
            this.systemScope = true;
            this.providedScope = false;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = false;
        } else if (Artifact.SCOPE_TEST.equals(scope)) {
            this.systemScope = true;
            this.providedScope = true;
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = true;
        } else {
            this.systemScope = false;
            this.providedScope = false;
            this.compileScope = false;
            this.runtimeScope = false;
            this.testScope = false;
        }
    }

    public boolean include(Artifact artifact) {
        if (Artifact.SCOPE_COMPILE.equals(artifact.getScope())) {
            return this.compileScope;
        }
        if (Artifact.SCOPE_RUNTIME.equals(artifact.getScope())) {
            return this.runtimeScope;
        }
        if (Artifact.SCOPE_TEST.equals(artifact.getScope())) {
            return this.testScope;
        }
        if (Artifact.SCOPE_PROVIDED.equals(artifact.getScope())) {
            return this.providedScope;
        }
        if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
            return this.systemScope;
        }
        return true;
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.compileScope ? 1 : 0);
        hash = hash * 31 + (this.runtimeScope ? 1 : 0);
        hash = hash * 31 + (this.testScope ? 1 : 0);
        hash = hash * 31 + (this.providedScope ? 1 : 0);
        hash = hash * 31 + (this.systemScope ? 1 : 0);
        hash = hash * 31 + (this.scope != null ? this.scope.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScopeArtifactFilter)) {
            return false;
        }
        ScopeArtifactFilter other = (ScopeArtifactFilter)obj;
        return this.compileScope == other.compileScope && this.runtimeScope == other.runtimeScope && this.testScope == other.testScope && this.providedScope == other.providedScope && this.systemScope == other.systemScope && ScopeArtifactFilter.equals(this.scope, other.scope);
    }

    private static boolean equals(String str1, String str2) {
        return str1 != null ? str1.equals(str2) : str2 == null;
    }
}

