/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndArtifactFilter
implements ArtifactFilter {
    private Set<ArtifactFilter> filters;

    public AndArtifactFilter() {
    }

    public AndArtifactFilter(List<ArtifactFilter> filters) {
        this.filters = new LinkedHashSet<ArtifactFilter>(filters);
    }

    @Override
    public boolean include(Artifact artifact) {
        boolean include = true;
        Iterator<ArtifactFilter> i = this.filters.iterator();
        while (i.hasNext() && include) {
            ArtifactFilter filter = i.next();
            if (filter.include(artifact)) continue;
            include = false;
        }
        return include;
    }

    public void add(ArtifactFilter artifactFilter) {
        if (this.filters == null) {
            this.filters = new LinkedHashSet<ArtifactFilter>();
        }
        this.filters.add(artifactFilter);
    }

    public List<ArtifactFilter> getFilters() {
        return new ArrayList<ArtifactFilter>(this.filters);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + ((Object)this.filters).hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AndArtifactFilter)) {
            return false;
        }
        AndArtifactFilter other = (AndArtifactFilter)obj;
        return ((Object)this.filters).equals(other.filters);
    }
}

