/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.repository.legacy.resolver.conflict.ConflictResolver;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactResolver.class)
public class DefaultArtifactResolver
implements ArtifactResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private ArtifactTransformationManager transformationManager;
    @Requirement
    protected ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactCollector artifactCollector;
    @Requirement
    private ResolutionErrorHandler resolutionErrorHandler;
    @Requirement
    private ArtifactMetadataSource source;
    @Requirement
    private PlexusContainer container;

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, TransferListener resolutionListener) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, resolutionListener, false);
    }

    @Override
    public void resolveAlways(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, null, true);
    }

    private void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, TransferListener downloadMonitor, boolean force) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            return;
        }
        if (Artifact.SCOPE_SYSTEM.equals(artifact.getScope())) {
            File systemFile = artifact.getFile();
            if (systemFile == null) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " has no file attached", artifact);
            }
            if (!systemFile.exists()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " not found in path: " + systemFile, artifact);
            }
            if (!systemFile.isFile()) {
                throw new ArtifactNotFoundException("System artifact: " + artifact + " is not a file: " + systemFile, artifact);
            }
            artifact.setResolved(true);
            return;
        }
        if (!artifact.isResolved()) {
            if ((artifact = localRepository.find(artifact)).isFromAuthoritativeRepository()) {
                return;
            }
            if (artifact.isSnapshot() && artifact.isResolved()) {
                return;
            }
            this.transformationManager.transformForResolve(artifact, remoteRepositories, localRepository);
            boolean localCopy = this.isLocalCopy(artifact);
            File destination = artifact.getFile();
            boolean resolved = false;
            if (force || !destination.exists() || artifact.isSnapshot() && !localCopy) {
                try {
                    if (artifact.getRepository() != null) {
                        this.wagonManager.getArtifact(artifact, artifact.getRepository(), downloadMonitor);
                    } else {
                        this.wagonManager.getArtifact(artifact, remoteRepositories, downloadMonitor);
                    }
                    if (!artifact.isResolved() && !destination.exists()) {
                        throw new ArtifactResolutionException("Failed to resolve artifact, possibly due to a repository list that is not appropriately equipped for this artifact's metadata.", artifact, remoteRepositories);
                    }
                }
                catch (ResourceDoesNotExistException e) {
                    throw new ArtifactNotFoundException(e.getMessage(), artifact, remoteRepositories, e);
                }
                catch (TransferFailedException e) {
                    throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
                }
                resolved = true;
            }
            if (destination.exists()) {
                artifact.setResolved(true);
            }
            if (artifact.isSnapshot() && !artifact.getBaseVersion().equals(artifact.getVersion())) {
                String version = artifact.getVersion();
                artifact.selectVersion(artifact.getBaseVersion());
                File copy = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
                if (resolved || !copy.exists()) {
                    try {
                        FileUtils.copyFile((File)destination, (File)copy);
                        copy.setLastModified(destination.lastModified());
                    }
                    catch (IOException e) {
                        throw new ArtifactResolutionException("Unable to copy resolved artifact for local use: " + e.getMessage(), artifact, remoteRepositories, e);
                    }
                }
                artifact.setFile(copy);
                artifact.selectVersion(version);
            }
        }
    }

    private boolean isLocalCopy(Artifact artifact) {
        boolean localCopy = false;
        for (ArtifactMetadata m : artifact.getMetadataList()) {
            Snapshot snapshot;
            Versioning versioning;
            SnapshotArtifactRepositoryMetadata snapshotMetadata;
            Metadata metadata;
            if (!(m instanceof SnapshotArtifactRepositoryMetadata) || (metadata = (snapshotMetadata = (SnapshotArtifactRepositoryMetadata)m).getMetadata()) == null || (versioning = metadata.getVersioning()) == null || (snapshot = versioning.getSnapshot()) == null) continue;
            localCopy = snapshot.isLocalCopy();
        }
        return localCopy;
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    @Override
    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners) throws ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set<Artifact> artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List<ResolutionListener> listeners, List<ConflictResolver> conflictResolvers) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(originatingArtifact).setResolveRoot(false).setArtifactDependencies(artifacts).setManagedVersionMap(managedVersions).setLocalRepository(localRepository).setRemoteRepostories(remoteRepositories).setFilter(filter).setListeners(listeners);
        return this.resolveWithExceptions(request);
    }

    public ArtifactResolutionResult resolveWithExceptions(ArtifactResolutionRequest request) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArtifactResolutionResult result = this.resolve(request);
        this.resolutionErrorHandler.throwErrors(request, result);
        return result;
    }

    @Override
    public ArtifactResolutionResult resolve(ArtifactResolutionRequest request) {
        Artifact rootArtifact = request.getArtifact();
        Set<Artifact> artifacts = request.getArtifactDependencies();
        Map managedVersions = request.getManagedVersionMap();
        ArtifactRepository localRepository = request.getLocalRepository();
        List<ArtifactRepository> remoteRepositories = request.getRemoteRepostories();
        List<ResolutionListener> listeners = request.getListeners();
        ArtifactFilter filter = request.getFilter();
        if (this.source == null) {
            try {
                this.source = (ArtifactMetadataSource)this.container.lookup(ArtifactMetadataSource.class);
            }
            catch (ComponentLookupException e) {
                e.printStackTrace();
            }
        }
        if (listeners == null) {
            listeners = new ArrayList<ResolutionListener>();
            if (this.logger.isDebugEnabled()) {
                listeners.add(new DebugResolutionListener(this.logger));
            }
            listeners.add(new WarningResolutionListener(this.logger));
        }
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        if (request.isResolveRoot() && rootArtifact.getFile() == null) {
            try {
                this.resolve(rootArtifact, remoteRepositories, localRepository);
            }
            catch (ArtifactResolutionException e) {
                result.addErrorArtifactException(e);
                return result;
            }
            catch (ArtifactNotFoundException e) {
                result.addMissingArtifact(request.getArtifact());
                return result;
            }
        }
        if (request.isResolveTransitively()) {
            try {
                Set<Artifact> directArtifacts = this.source.retrieve(rootArtifact, localRepository, remoteRepositories).getArtifacts();
                if (artifacts == null || artifacts.isEmpty()) {
                    artifacts = directArtifacts;
                } else {
                    ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
                    allArtifacts.addAll(artifacts);
                    allArtifacts.addAll(directArtifacts);
                    LinkedHashMap<String, Artifact> mergedArtifacts = new LinkedHashMap<String, Artifact>();
                    for (Artifact artifact : allArtifacts) {
                        String conflictId = artifact.getDependencyConflictId();
                        if (mergedArtifacts.containsKey(conflictId)) continue;
                        mergedArtifacts.put(conflictId, artifact);
                    }
                    artifacts = new LinkedHashSet(mergedArtifacts.values());
                }
            }
            catch (ArtifactMetadataRetrievalException e) {
                return result;
            }
        }
        if (artifacts == null || artifacts.isEmpty()) {
            if (request.isResolveRoot()) {
                result.addArtifact(rootArtifact);
            }
            return result;
        }
        result = this.artifactCollector.collect(artifacts, rootArtifact, managedVersions, localRepository, remoteRepositories, this.source, filter, listeners, null);
        if (result.hasMetadataResolutionExceptions() || result.hasVersionRangeViolations() || result.hasCircularDependencyExceptions()) {
            return result;
        }
        if (result.getArtifacts() != null) {
            for (Artifact artifact : result.getArtifacts()) {
                try {
                    this.resolve(artifact, remoteRepositories, localRepository, request.getTransferListener());
                }
                catch (ArtifactNotFoundException anfe) {
                    result.addMissingArtifact(artifact);
                }
                catch (ArtifactResolutionException e) {
                    result.addErrorArtifactException(e);
                }
            }
        }
        if (request.isResolveRoot()) {
            LinkedHashSet<Artifact> allArtifacts = new LinkedHashSet<Artifact>();
            allArtifacts.add(rootArtifact);
            allArtifacts.addAll(result.getArtifacts());
            result.setArtifacts(allArtifacts);
        }
        return result;
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.resolve(artifact, remoteRepositories, localRepository, null);
    }
}

