/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.wagon.events.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolutionRequest {
    private Artifact artifact;
    private Set<Artifact> artifactDependencies;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactFilter filter;
    private List<ResolutionListener> listeners = new ArrayList<ResolutionListener>();
    private Map managedVersionMap;
    private TransferListener transferListener;
    private boolean resolveRoot = true;
    private boolean resolveTransitively = false;

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResolutionRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public ArtifactResolutionRequest setArtifactDependencies(Set<Artifact> artifactDependencies) {
        this.artifactDependencies = artifactDependencies;
        return this;
    }

    public Set<Artifact> getArtifactDependencies() {
        return this.artifactDependencies;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public ArtifactResolutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public List<ArtifactRepository> getRemoteRepostories() {
        return this.remoteRepositories;
    }

    public ArtifactResolutionRequest setRemoteRepostories(List<ArtifactRepository> remoteRepostories) {
        this.remoteRepositories = remoteRepostories;
        return this;
    }

    public ArtifactFilter getFilter() {
        return this.filter;
    }

    public ArtifactResolutionRequest setFilter(ArtifactFilter filter) {
        this.filter = filter;
        return this;
    }

    public List<ResolutionListener> getListeners() {
        return this.listeners;
    }

    public ArtifactResolutionRequest setListeners(List<ResolutionListener> listeners) {
        this.listeners = listeners;
        return this;
    }

    public ArtifactResolutionRequest addListener(ResolutionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Map getManagedVersionMap() {
        return this.managedVersionMap;
    }

    public ArtifactResolutionRequest setManagedVersionMap(Map managedVersionMap) {
        this.managedVersionMap = managedVersionMap;
        return this;
    }

    public ArtifactResolutionRequest setResolveRoot(boolean resolveRoot) {
        this.resolveRoot = resolveRoot;
        return this;
    }

    public boolean isResolveRoot() {
        return this.resolveRoot;
    }

    public ArtifactResolutionRequest setResolveTransitively(boolean resolveDependencies) {
        this.resolveTransitively = resolveDependencies;
        return this;
    }

    public boolean isResolveTransitively() {
        return this.resolveTransitively;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public ArtifactResolutionRequest setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append("REQUEST: ").append("\n").append("artifact: ").append(this.artifact).append("\n").append(this.artifactDependencies).append("\n").append("localRepository: ").append(this.localRepository).append("\n").append("remoteRepositories: ").append(this.remoteRepositories).append("\n");
        return sb.toString();
    }
}

