/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataDeploymentException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataInstallationException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataReadException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.repository.legacy.UpdateCheckManager;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RepositoryMetadataManager.class)
public class DefaultRepositoryMetadataManager
extends AbstractLogEnabled
implements RepositoryMetadataManager {
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private UpdateCheckManager updateCheckManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void resolve(RepositoryMetadata metadata, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataResolutionException {
        for (ArtifactRepository repository : remoteRepositories) {
            policy = metadata.isSnapshot() != false ? repository.getSnapshots() : repository.getReleases();
            file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, repository));
            if (this.updateCheckManager.isUpdateRequired(metadata, repository, file)) {
                this.getLogger().info(metadata.getKey() + ": checking for updates from " + repository.getId());
                try {
                    this.wagonManager.getArtifactMetadata(metadata, repository, file, policy.getChecksumPolicy());
                }
                catch (ResourceDoesNotExistException e) {
                    this.getLogger().debug(metadata + " could not be found on repository: " + repository.getId());
                    if (!file.exists()) ** GOTO lbl23
                    file.delete();
                }
                catch (TransferFailedException e) {
                    this.getLogger().warn(metadata + " could not be retrieved from repository: " + repository.getId() + " due to an error: " + e.getMessage());
                    this.getLogger().debug("Exception", (Throwable)e);
                }
                finally {
                    this.updateCheckManager.touch(metadata, repository, file);
                }
            } else {
                this.getLogger().debug("Skipping metadata update of " + metadata.getKey() + " from " + repository.getId());
            }
lbl23:
            // 5 sources

            if (!file.exists()) continue;
            file.setLastModified(System.currentTimeMillis());
        }
        try {
            this.mergeMetadata(metadata, remoteRepositories, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataResolutionException("Unable to store local copy of metadata: " + e.getMessage(), e);
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException("Unable to read local copy of metadata: " + e.getMessage(), e);
        }
    }

    private void mergeMetadata(RepositoryMetadata metadata, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws RepositoryMetadataStoreException, RepositoryMetadataReadException {
        HashMap<ArtifactRepository, Metadata> previousMetadata = new HashMap<ArtifactRepository, Metadata>();
        ArtifactRepository selected = null;
        for (ArtifactRepository repository : remoteRepositories) {
            ArtifactRepositoryPolicy policy = metadata.isSnapshot() ? repository.getSnapshots() : repository.getReleases();
            if (!policy.isEnabled() || !this.loadMetadata(metadata, repository, localRepository, previousMetadata)) continue;
            metadata.setRepository(repository);
            selected = repository;
        }
        if (this.loadMetadata(metadata, localRepository, localRepository, previousMetadata)) {
            metadata.setRepository(null);
            selected = localRepository;
        }
        this.updateSnapshotMetadata(metadata, previousMetadata, selected, localRepository);
    }

    private void updateSnapshotMetadata(RepositoryMetadata metadata, Map<ArtifactRepository, Metadata> previousMetadata, ArtifactRepository selected, ArtifactRepository localRepository) throws RepositoryMetadataStoreException {
        if (metadata.isSnapshot()) {
            Metadata prevMetadata = metadata.getMetadata();
            for (ArtifactRepository repository : previousMetadata.keySet()) {
                Metadata m = previousMetadata.get(repository);
                if (repository.equals(selected)) {
                    if (m.getVersioning() == null) {
                        m.setVersioning(new Versioning());
                    }
                    if (m.getVersioning().getSnapshot() != null) continue;
                    m.getVersioning().setSnapshot(new Snapshot());
                    continue;
                }
                if (m.getVersioning() == null || m.getVersioning().getSnapshot() == null || !m.getVersioning().getSnapshot().isLocalCopy()) continue;
                m.getVersioning().getSnapshot().setLocalCopy(false);
                metadata.setMetadata(m);
                metadata.storeInLocalRepository(localRepository, repository);
            }
            metadata.setMetadata(prevMetadata);
        }
    }

    private boolean loadMetadata(RepositoryMetadata repoMetadata, ArtifactRepository remoteRepository, ArtifactRepository localRepository, Map<ArtifactRepository, Metadata> previousMetadata) throws RepositoryMetadataReadException {
        boolean setRepository = false;
        File metadataFile = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(repoMetadata, remoteRepository));
        if (metadataFile.exists()) {
            Metadata metadata = DefaultRepositoryMetadataManager.readMetadata(metadataFile);
            if (repoMetadata.isSnapshot() && previousMetadata != null) {
                previousMetadata.put(remoteRepository, metadata);
            }
            if (repoMetadata.getMetadata() != null) {
                setRepository = repoMetadata.getMetadata().merge(metadata);
            } else {
                repoMetadata.setMetadata(metadata);
                setRepository = true;
            }
        }
        return setRepository;
    }

    protected static Metadata readMetadata(File mappingFile) throws RepositoryMetadataReadException {
        Metadata result;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)mappingFile);
            MetadataXpp3Reader mappingReader = new MetadataXpp3Reader();
            result = mappingReader.read((Reader)reader, false);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "'", e);
        }
        catch (IOException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e.getMessage(), e);
        }
        catch (XmlPullParserException e) {
            throw new RepositoryMetadataReadException("Cannot read metadata from '" + mappingFile + "': " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return result;
    }

    @Override
    public void resolveAlways(RepositoryMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataResolutionException {
        File file;
        try {
            file = this.getArtifactMetadataFromDeploymentRepository(metadata, localRepository, remoteRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataResolutionException(metadata + " could not be retrieved from repository: " + remoteRepository.getId() + " due to an error: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            if (file.exists()) {
                Metadata prevMetadata = DefaultRepositoryMetadataManager.readMetadata(file);
                metadata.setMetadata(prevMetadata);
            }
        }
        catch (RepositoryMetadataReadException e) {
            throw new RepositoryMetadataResolutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getArtifactMetadataFromDeploymentRepository(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws TransferFailedException {
        File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, remoteRepository));
        try {
            this.wagonManager.getArtifactMetadataFromDeploymentRepository(metadata, remoteRepository, file, "warn");
        }
        catch (ResourceDoesNotExistException e) {
            this.getLogger().info(metadata + " could not be found on repository: " + remoteRepository.getId() + ", so will be created");
            if (file.exists()) {
                file.delete();
            }
        }
        finally {
            if (metadata instanceof RepositoryMetadata) {
                this.updateCheckManager.touch((RepositoryMetadata)metadata, remoteRepository, file);
            }
        }
        return file;
    }

    @Override
    public void deploy(ArtifactMetadata metadata, ArtifactRepository localRepository, ArtifactRepository deploymentRepository) throws RepositoryMetadataDeploymentException {
        File file;
        if (metadata instanceof RepositoryMetadata) {
            this.getLogger().info("Retrieving previous metadata from " + deploymentRepository.getId());
            try {
                file = this.getArtifactMetadataFromDeploymentRepository(metadata, localRepository, deploymentRepository);
            }
            catch (TransferFailedException e) {
                throw new RepositoryMetadataDeploymentException(metadata + " could not be retrieved from repository: " + deploymentRepository.getId() + " due to an error: " + e.getMessage(), (Exception)((Object)e));
            }
        } else {
            file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata(metadata, deploymentRepository));
        }
        try {
            metadata.storeInLocalRepository(localRepository, deploymentRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataDeploymentException("Error installing metadata: " + e.getMessage(), e);
        }
        try {
            this.wagonManager.putArtifactMetadata(file, metadata, deploymentRepository);
        }
        catch (TransferFailedException e) {
            throw new RepositoryMetadataDeploymentException("Error while deploying metadata: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void install(ArtifactMetadata metadata, ArtifactRepository localRepository) throws RepositoryMetadataInstallationException {
        try {
            metadata.storeInLocalRepository(localRepository, localRepository);
        }
        catch (RepositoryMetadataStoreException e) {
            throw new RepositoryMetadataInstallationException("Error installing metadata: " + e.getMessage(), e);
        }
    }
}

