/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.LegacyArtifactMetadata;
import org.apache.maven.artifact.metadata.SnapshotArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.transform.AbstractVersionTransformation;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.codehaus.plexus.util.StringUtils;

public class SnapshotTransformation
extends AbstractVersionTransformation {
    private String deploymentTimestamp;

    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        if (artifact.isSnapshot()) {
            String version = this.resolveVersion(artifact, localRepository, remoteRepositories);
            artifact.updateVersion(version, localRepository);
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        if (artifact.isSnapshot()) {
            SnapshotArtifactRepositoryMetadata metadata = new SnapshotArtifactRepositoryMetadata(artifact);
            metadata.getMetadata().getVersioning().getSnapshot().setLocalCopy(true);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        if (artifact.isSnapshot()) {
            int buildNumber = this.resolveLatestSnapshotBuildNumber(artifact, localRepository, remoteRepository);
            Snapshot snapshot = new Snapshot();
            snapshot.setTimestamp(this.getDeploymentTimestamp());
            snapshot.setBuildNumber(buildNumber + 1);
            SnapshotArtifactRepositoryMetadata metadata = new SnapshotArtifactRepositoryMetadata(artifact, snapshot);
            artifact.setResolvedVersion(this.constructVersion(metadata.getMetadata().getVersioning(), artifact.getBaseVersion()));
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
    }

    public String getDeploymentTimestamp() {
        if (this.deploymentTimestamp == null) {
            this.deploymentTimestamp = SnapshotArtifactMetadata.getUtcDateFormatter().format(new Date());
        }
        return this.deploymentTimestamp;
    }

    protected LegacyArtifactMetadata createLegacyMetadata(Artifact artifact) {
        return new SnapshotArtifactMetadata(artifact);
    }

    protected String constructVersion(Versioning versioning, String baseVersion) {
        String version = null;
        Snapshot snapshot = versioning.getSnapshot();
        if (snapshot != null) {
            if (snapshot.isLocalCopy()) {
                version = baseVersion;
            } else if (snapshot.getTimestamp() != null && snapshot.getBuildNumber() > 0) {
                String newVersion = snapshot.getTimestamp() + "-" + snapshot.getBuildNumber();
                version = StringUtils.replace((String)baseVersion, (String)"SNAPSHOT", (String)newVersion);
            }
        }
        return version;
    }

    private int resolveLatestSnapshotBuildNumber(Artifact artifact, ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        SnapshotArtifactRepositoryMetadata metadata = new SnapshotArtifactRepositoryMetadata(artifact);
        if (!this.wagonManager.isOnline()) {
            this.getLogger().debug("System is offline. Cannot resolve metadata:\n" + metadata.extendedToString() + "\n\n");
            this.getLogger().info("System is offline. Assuming build number of 0 for " + metadata.getGroupId() + ":" + metadata.getArtifactId() + " snapshot.");
            return 0;
        }
        this.getLogger().info("Retrieving previous build number from " + remoteRepository.getId());
        this.repositoryMetadataManager.resolveAlways(metadata, localRepository, remoteRepository);
        int buildNumber = 0;
        Metadata repoMetadata = metadata.getMetadata();
        if (repoMetadata != null) {
            if (repoMetadata.getVersioning() != null && repoMetadata.getVersioning().getSnapshot() != null) {
                buildNumber = repoMetadata.getVersioning().getSnapshot().getBuildNumber();
            }
        } else {
            try {
                SnapshotArtifactMetadata snapshotMetadata = new SnapshotArtifactMetadata(artifact);
                snapshotMetadata.retrieveFromRemoteRepository(remoteRepository, this.wagonManager, "warn");
                this.getLogger().warn("Using old-style versioning metadata from remote repo for " + artifact);
                buildNumber = snapshotMetadata.getBuildNumber();
            }
            catch (ResourceDoesNotExistException e1) {
                this.getLogger().debug("Unable to find legacy metadata - ignoring");
            }
        }
        return buildNumber;
    }
}

