/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.WarningResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultArtifactResolver
extends AbstractLogEnabled
implements ArtifactResolver {
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    protected ArtifactFactory artifactFactory;
    private ArtifactCollector artifactCollector;

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException {
        this.resolve(artifact, remoteRepositories, localRepository, false);
    }

    public void resolveAlways(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException {
        this.resolve(artifact, remoteRepositories, localRepository, true);
    }

    private void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository, boolean force) throws ArtifactResolutionException {
        block16: {
            if (artifact != null) {
                if ("system".equals(artifact.getScope())) {
                    File systemFile = artifact.getFile();
                    if (!systemFile.exists()) {
                        throw new ArtifactResolutionException("System artifact: " + artifact.getId() + " not found in path: " + systemFile, artifact);
                    }
                    artifact.setResolved(true);
                } else if (!artifact.isResolved()) {
                    String localPath = localRepository.pathOf(artifact);
                    artifact.setFile(new File(localRepository.getBasedir(), localPath));
                    try {
                        this.transformationManager.transformForResolve(artifact, remoteRepositories, localRepository);
                    }
                    catch (ArtifactMetadataRetrievalException e) {
                        throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
                    }
                    File destination = artifact.getFile();
                    if (!destination.exists() || force) {
                        if (!this.wagonManager.isOnline()) {
                            this.getLogger().debug("System is offline. Cannot resolve artifact: " + artifact.getId() + ".");
                            return;
                        }
                        try {
                            if (artifact.getRepository() != null) {
                                this.wagonManager.getArtifact(artifact, artifact.getRepository());
                            } else {
                                this.wagonManager.getArtifact(artifact, remoteRepositories);
                            }
                            if (!artifact.isResolved()) {
                                throw new ArtifactResolutionException("Failed to resolve artifact, possibly due to a repository list that is not appropriately equipped for this artifact's metadata.", artifact, remoteRepositories);
                            }
                            break block16;
                        }
                        catch (ResourceDoesNotExistException e) {
                            throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
                        }
                        catch (TransferFailedException e) {
                            throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, (Throwable)e);
                        }
                    }
                    if (destination.exists()) {
                        artifact.setResolved(true);
                    }
                }
            }
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException {
        ArrayList<Object> listeners = new ArrayList<Object>();
        if (this.getLogger().isDebugEnabled()) {
            listeners.add(new DebugResolutionListener(this.getLogger()));
        }
        listeners.add(new WarningResolutionListener(this.getLogger()));
        return this.resolveTransitively(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        ArtifactResolutionResult artifactResolutionResult = this.artifactCollector.collect(artifacts, originatingArtifact, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
        Iterator i = artifactResolutionResult.getArtifactResolutionNodes().iterator();
        while (i.hasNext()) {
            ResolutionNode node = (ResolutionNode)i.next();
            this.resolve(node.getArtifact(), node.getRemoteRepositories(), localRepository);
        }
        return artifactResolutionResult;
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, localRepository, remoteRepositories, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, Artifact originatingArtifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, List listeners) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, null, listeners);
    }
}

