/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.codehaus.plexus.logging.Logger;

public class DebugResolutionListener
implements ResolutionListener {
    private Logger logger;
    private String indent = "";

    public DebugResolutionListener(Logger logger) {
        this.logger = logger;
    }

    public void testArtifact(Artifact node) {
    }

    public void startProcessChildren(Artifact artifact) {
        this.indent = this.indent + "  ";
    }

    public void endProcessChildren(Artifact artifact) {
        this.indent = this.indent.substring(2);
    }

    public void includeArtifact(Artifact artifact) {
        this.logger.debug(this.indent + artifact.getId() + " (selected for " + artifact.getScope() + ")");
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        this.logger.debug(this.indent + omitted.getId() + " (removed - nearer found: " + kept.getVersion() + ")");
    }

    public void omitForCycle(Artifact omitted) {
        this.logger.debug(this.indent + omitted.getId() + " (removed - causes a cycle in the graph)");
    }

    public void updateScopeCurrentPom(Artifact artifact, String scope) {
        this.updateScope(artifact, scope);
    }

    public void updateScope(Artifact artifact, String scope) {
        this.logger.debug(this.indent + artifact.getId() + " (setting scope to: " + scope + ")");
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.logger.debug(this.indent + artifact.getId() + " (setting version to: " + artifact.getVersion() + " from range: " + artifact.getVersionRange() + ")");
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        String msg = this.indent + artifact.getId();
        msg = msg + " (";
        if (replacement.getVersion() != null) {
            msg = msg + "applying version: " + replacement.getVersion() + ";";
        }
        if (replacement.getScope() != null) {
            msg = msg + "applying scope: " + replacement.getScope();
        }
        msg = msg + ")";
        this.logger.debug(msg);
    }
}

