/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

public class DefaultArtifactRepositoryFactory
implements ArtifactRepositoryFactory {
    private String globalUpdatePolicy;
    private String globalChecksumPolicy;

    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout) {
        return new DefaultArtifactRepository(id, url, repositoryLayout);
    }

    public ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        if (this.globalUpdatePolicy != null) {
            snapshots.setUpdatePolicy(this.globalUpdatePolicy);
            releases.setUpdatePolicy(this.globalUpdatePolicy);
        }
        if (this.globalChecksumPolicy != null) {
            snapshots.setChecksumPolicy(this.globalChecksumPolicy);
            releases.setChecksumPolicy(this.globalChecksumPolicy);
        }
        return new DefaultArtifactRepository(id, url, repositoryLayout, snapshots, releases);
    }

    public void setGlobalUpdatePolicy(String updatePolicy) {
        this.globalUpdatePolicy = updatePolicy;
    }

    public void setGlobalChecksumPolicy(String checksumPolicy) {
        this.globalChecksumPolicy = checksumPolicy;
    }

    public void setGlobalEnable(boolean enable) {
    }
}

