/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.transform.ArtifactTransformationManager;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactDeployer
extends AbstractLogEnabled
implements ArtifactDeployer {
    private WagonManager wagonManager;
    private ArtifactTransformationManager transformationManager;
    private RepositoryMetadataManager repositoryMetadataManager;

    public void deploy(String basedir, String finalName, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        String extension = artifact.getArtifactHandler().getExtension();
        File source = new File(basedir, finalName + "." + extension);
        this.deploy(source, artifact, deploymentRepository, localRepository);
    }

    public void deploy(File source, Artifact artifact, ArtifactRepository deploymentRepository, ArtifactRepository localRepository) throws ArtifactDeploymentException {
        if (!this.wagonManager.isOnline()) {
            this.getLogger().warn("System is offline. Cannot deploy artifact: " + artifact.getId() + ".");
            return;
        }
        try {
            this.transformationManager.transformForDeployment(artifact, deploymentRepository, localRepository);
            File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
            if (!artifactFile.equals(source)) {
                FileUtils.copyFile((File)source, (File)artifactFile);
            }
            this.wagonManager.putArtifact(source, artifact, deploymentRepository);
            Iterator i = artifact.getMetadataList().iterator();
            while (i.hasNext()) {
                ArtifactMetadata metadata = (ArtifactMetadata)i.next();
                this.repositoryMetadataManager.deploy(metadata, localRepository, deploymentRepository);
            }
        }
        catch (TransferFailedException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: ", (Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: ", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArtifactDeploymentException("Error deploying artifact: ", (Throwable)e);
        }
    }
}

