/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Parent;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Mixin
extends Parent
implements Serializable,
InputLocationTracker {
    final String classifier;
    final String extension;

    protected Mixin(Builder builder) {
        super(builder);
        String string = builder.classifier != null ? builder.classifier : (this.classifier = builder.base != null ? builder.base.classifier : null);
        this.extension = builder.extension != null ? builder.extension : (builder.base != null ? builder.base.extension : null);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Mixin.newBuilder(this);
    }

    @Override
    @Nonnull
    public Mixin withGroupId(String groupId) {
        return Mixin.newBuilder(this, true).groupId(groupId).build();
    }

    @Override
    @Nonnull
    public Mixin withArtifactId(String artifactId) {
        return Mixin.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Override
    @Nonnull
    public Mixin withVersion(String version) {
        return Mixin.newBuilder(this, true).version(version).build();
    }

    @Override
    @Nonnull
    public Mixin withRelativePath(String relativePath) {
        return Mixin.newBuilder(this, true).relativePath(relativePath).build();
    }

    @Nonnull
    public Mixin withClassifier(String classifier) {
        return Mixin.newBuilder(this, true).classifier(classifier).build();
    }

    @Nonnull
    public Mixin withExtension(String extension) {
        return Mixin.newBuilder(this, true).extension(extension).build();
    }

    @Nonnull
    public static Mixin newInstance() {
        return Mixin.newInstance(true);
    }

    @Nonnull
    public static Mixin newInstance(boolean withDefaults) {
        return Mixin.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Mixin.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Mixin from) {
        return Mixin.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Mixin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends Parent.Builder {
        Mixin base;
        String classifier;
        String extension;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Mixin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.classifier = base.classifier;
                this.extension = base.extension;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Override
        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        @Nonnull
        public Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }

        @Nonnull
        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Nonnull
        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Mixin build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.relativePath != null && this.relativePath != this.base.relativePath || this.classifier != null && this.classifier != this.base.classifier || this.extension != null && this.extension != this.base.extension)) {
                return this.base;
            }
            return new Mixin(this);
        }
    }
}

