/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.api.request;

public class Paging {
    protected final int pageSize;
    protected final int pageOffset;

    public Paging(int pageSize, int pageOffset) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize");
        }
        if (pageOffset < 0) {
            throw new IllegalArgumentException("pageOffset");
        }
        this.pageSize = pageSize;
        this.pageOffset = pageOffset;
    }

    public Paging(int pageSize) {
        this(pageSize, 0);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public Paging nextPage() {
        return new Paging(this.pageSize, this.pageOffset + 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{pageSize=" + this.pageSize + ", pageOffset=" + this.pageOffset + "}";
    }
}

