/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.util.Map;
import java.util.Objects;

public final class Record {
    public static final EntryKey REPOSITORY_ID = new EntryKey("repositoryId", String.class);
    public static final EntryKey ALL_GROUPS = new EntryKey("allGroups", String[].class);
    public static final EntryKey ROOT_GROUPS = new EntryKey("rootGroups", String[].class);
    public static final EntryKey REC_MODIFIED = new EntryKey("recordModified", Long.class);
    public static final EntryKey GROUP_ID = new EntryKey("groupId", String.class);
    public static final EntryKey ARTIFACT_ID = new EntryKey("artifactId", String.class);
    public static final EntryKey VERSION = new EntryKey("version", String.class);
    public static final EntryKey CLASSIFIER = new EntryKey("classifier", String.class);
    public static final EntryKey PACKAGING = new EntryKey("packaging", String.class);
    public static final EntryKey FILE_EXTENSION = new EntryKey("fileExtension", String.class);
    public static final EntryKey FILE_MODIFIED = new EntryKey("fileModified", Long.class);
    public static final EntryKey FILE_SIZE = new EntryKey("fileSize", Long.class);
    public static final EntryKey HAS_SOURCES = new EntryKey("hasSources", Boolean.class);
    public static final EntryKey HAS_JAVADOC = new EntryKey("hasJavadoc", Boolean.class);
    public static final EntryKey HAS_SIGNATURE = new EntryKey("hasSignature", Boolean.class);
    public static final EntryKey NAME = new EntryKey("name", String.class);
    public static final EntryKey DESCRIPTION = new EntryKey("description", String.class);
    public static final EntryKey SHA1 = new EntryKey("sha1", String.class);
    public static final EntryKey CLASSNAMES = new EntryKey("classNames", String[].class);
    public static final EntryKey PLUGIN_PREFIX = new EntryKey("pluginPrefix", String.class);
    public static final EntryKey PLUGIN_GOALS = new EntryKey("pluginGoals", String[].class);
    public static final EntryKey OSGI_BUNDLE_SYMBOLIC_NAME = new EntryKey("Bundle-SymbolicName", String.class);
    public static final EntryKey OSGI_BUNDLE_VERSION = new EntryKey("Bundle-Version", String.class);
    public static final EntryKey OSGI_EXPORT_PACKAGE = new EntryKey("Export-Package", String.class);
    public static final EntryKey OSGI_EXPORT_SERVICE = new EntryKey("Export-Service", String.class);
    public static final EntryKey OSGI_BUNDLE_DESCRIPTION = new EntryKey("Bundle-Description", String.class);
    public static final EntryKey OSGI_BUNDLE_NAME = new EntryKey("Bundle-Name", String.class);
    public static final EntryKey OSGI_BUNDLE_LICENSE = new EntryKey("Bundle-License", String.class);
    public static final EntryKey OSGI_EXPORT_DOCURL = new EntryKey("Bundle-DocURL", String.class);
    public static final EntryKey OSGI_IMPORT_PACKAGE = new EntryKey("Import-Package", String.class);
    public static final EntryKey OSGI_REQUIRE_BUNDLE = new EntryKey("Require-Bundle", String.class);
    public static final EntryKey OSGI_PROVIDE_CAPABILITY = new EntryKey("Provide-Capability", String.class);
    public static final EntryKey OSGI_REQUIRE_CAPABILITY = new EntryKey("Require-Capability", String.class);
    public static final EntryKey OSGI_FRAGMENT_HOST = new EntryKey("Fragment-Host", String.class);
    public static final EntryKey OSGI_BREE = new EntryKey("Bundle-RequiredExecutionEnvironment", String.class);
    public static final EntryKey SHA_256 = new EntryKey("sha256", String.class);
    private final Type type;
    private final Map<EntryKey, Object> expanded;

    public Record(Type type, Map<EntryKey, Object> expanded) {
        this.type = type;
        this.expanded = expanded;
    }

    public Type getType() {
        return this.type;
    }

    public Map<EntryKey, Object> getExpanded() {
        return this.expanded;
    }

    boolean containsKey(EntryKey entryKey) {
        return this.expanded.containsKey(entryKey);
    }

    public Object get(EntryKey entryKey) {
        return this.expanded.get(entryKey);
    }

    public String getString(EntryKey entryKey) {
        if (!String.class.isAssignableFrom(entryKey.proto)) {
            throw new IllegalArgumentException("Key " + String.valueOf(entryKey) + " does not hold type compatible to java.lang.String");
        }
        return (String)this.expanded.get(entryKey);
    }

    public String[] getStringArray(EntryKey entryKey) {
        if (!String[].class.isAssignableFrom(entryKey.proto)) {
            throw new IllegalArgumentException("Key " + String.valueOf(entryKey) + " does not hold type compatible to java.lang.String[]");
        }
        return (String[])this.expanded.get(entryKey);
    }

    public Long getLong(EntryKey entryKey) {
        if (!Long.class.isAssignableFrom(entryKey.proto)) {
            throw new IllegalArgumentException("Key " + String.valueOf(entryKey) + " does not hold type compatible to java.lang.Long");
        }
        return (Long)this.expanded.get(entryKey);
    }

    public Boolean getBoolean(EntryKey entryKey) {
        if (!Boolean.class.isAssignableFrom(entryKey.proto)) {
            throw new IllegalArgumentException("Key " + String.valueOf(entryKey) + " does not hold type compatible to java.lang.Boolean");
        }
        return (Boolean)this.expanded.get(entryKey);
    }

    public Object put(EntryKey entryKey, Object value) {
        if (value == null) {
            return this.expanded.remove(entryKey);
        }
        if (!entryKey.proto.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Key " + String.valueOf(entryKey) + " does not accepts value " + String.valueOf(value));
        }
        return this.expanded.put(entryKey, value);
    }

    public String toString() {
        return "Record{type=" + String.valueOf((Object)this.type) + ", expanded=" + String.valueOf(this.expanded) + "}";
    }

    public static enum Type {
        DESCRIPTOR,
        ARTIFACT_ADD,
        ARTIFACT_REMOVE,
        ALL_GROUPS,
        ROOT_GROUPS;

    }

    public static final class EntryKey {
        private final String name;
        private final Class<?> proto;

        public EntryKey(String name, Class<?> proto) {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(proto, "proto is null");
            this.name = name;
            this.proto = proto;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryKey entryKey = (EntryKey)o;
            return Objects.equals(this.name, entryKey.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "Key{name='" + this.name + "', type=" + this.proto.getSimpleName() + "}";
        }
    }
}

