/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.maven.index.reader.WritableResourceHandler;

public class PathWritableResource
implements WritableResourceHandler.WritableResource {
    private final Path path;

    public PathWritableResource(Path path) {
        Objects.requireNonNull(path, "path cannot be null");
        this.path = path;
    }

    @Override
    public OutputStream write() throws IOException {
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public InputStream read() throws IOException {
        try {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
    }
}

