/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.Utils;

public class RecordCompactor
implements Function<Record, Map<String, String>> {
    @Override
    public Map<String, String> apply(Record record) {
        if (Record.Type.DESCRIPTOR == record.getType()) {
            return RecordCompactor.compactDescriptor(record);
        }
        if (Record.Type.ALL_GROUPS == record.getType()) {
            return RecordCompactor.compactAllGroups(record);
        }
        if (Record.Type.ROOT_GROUPS == record.getType()) {
            return RecordCompactor.compactRootGroups(record);
        }
        if (Record.Type.ARTIFACT_REMOVE == record.getType()) {
            return RecordCompactor.compactDeletedArtifact(record);
        }
        if (Record.Type.ARTIFACT_ADD == record.getType()) {
            return RecordCompactor.compactAddedArtifact(record);
        }
        throw new IllegalArgumentException("Unknown record: " + String.valueOf(record));
    }

    private static Map<String, String> compactDescriptor(Record record) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("DESCRIPTOR", "NexusIndex");
        result.put("IDXINFO", "1.0|" + record.getString(Record.REPOSITORY_ID));
        return result;
    }

    private static Map<String, String> compactAllGroups(Record record) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("allGroups", "allGroups");
        RecordCompactor.putIfNotNullAsStringArray(record.getStringArray(Record.ALL_GROUPS), result, "allGroupsList");
        return result;
    }

    private static Map<String, String> compactRootGroups(Record record) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("rootGroups", "allGroups");
        RecordCompactor.putIfNotNullAsStringArray(record.getStringArray(Record.ROOT_GROUPS), result, "rootGroupsList");
        return result;
    }

    private static Map<String, String> compactDeletedArtifact(Record record) {
        HashMap<String, String> result = new HashMap<String, String>();
        RecordCompactor.putIfNotNullTS(record.getLong(Record.REC_MODIFIED), result, "m");
        result.put("del", RecordCompactor.compactUinfo(record));
        return result;
    }

    private static Map<String, String> compactAddedArtifact(Record record) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("u", RecordCompactor.compactUinfo(record));
        String info = Utils.nvl(record.getString(Record.PACKAGING)) + "|" + record.getLong(Record.FILE_MODIFIED) + "|" + record.getLong(Record.FILE_SIZE) + "|" + (record.getBoolean(Record.HAS_SOURCES) != false ? "1" : "0") + "|" + (record.getBoolean(Record.HAS_JAVADOC) != false ? "1" : "0") + "|" + (record.getBoolean(Record.HAS_SIGNATURE) != false ? "1" : "0") + "|" + Utils.nvl(record.getString(Record.FILE_EXTENSION));
        result.put("i", info);
        RecordCompactor.putIfNotNullTS(record.getLong(Record.REC_MODIFIED), result, "m");
        RecordCompactor.putIfNotNull(record.getString(Record.NAME), result, "n");
        RecordCompactor.putIfNotNull(record.getString(Record.DESCRIPTION), result, "d");
        RecordCompactor.putIfNotNull(record.getString(Record.SHA1), result, "1");
        RecordCompactor.putIfNotNullAsStringArray(record.getStringArray(Record.CLASSNAMES), result, "classnames");
        RecordCompactor.putIfNotNull(record.getString(Record.PLUGIN_PREFIX), result, "px");
        RecordCompactor.putIfNotNullAsStringArray(record.getStringArray(Record.PLUGIN_GOALS), result, "gx");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_BUNDLE_SYMBOLIC_NAME), result, "Bundle-SymbolicName");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_BUNDLE_VERSION), result, "Bundle-Version");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_EXPORT_PACKAGE), result, "Export-Package");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_EXPORT_SERVICE), result, "Export-Service");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_BUNDLE_DESCRIPTION), result, "Bundle-Description");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_BUNDLE_NAME), result, "Bundle-Name");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_BUNDLE_LICENSE), result, "Bundle-License");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_EXPORT_DOCURL), result, "Bundle-DocURL");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_IMPORT_PACKAGE), result, "Import-Package");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_REQUIRE_BUNDLE), result, "Require-Bundle");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_PROVIDE_CAPABILITY), result, "Provide-Capability");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_REQUIRE_CAPABILITY), result, "Require-Capability");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_FRAGMENT_HOST), result, "Fragment-Host");
        RecordCompactor.putIfNotNull(record.getString(Record.OSGI_BREE), result, "Bundle-RequiredExecutionEnvironment");
        RecordCompactor.putIfNotNull(record.getString(Record.SHA_256), result, "sha256");
        return result;
    }

    private static String compactUinfo(Record record) {
        String classifier = record.getString(Record.CLASSIFIER);
        StringBuilder sb = new StringBuilder().append(record.getString(Record.GROUP_ID)).append("|").append(record.getString(Record.ARTIFACT_ID)).append("|").append(record.getString(Record.VERSION)).append("|").append(Utils.nvl(classifier));
        if (classifier != null) {
            sb.append("|").append(record.get(Record.FILE_EXTENSION));
        }
        return sb.toString();
    }

    private static void putIfNotNull(String source, Map<String, String> target, String targetName) {
        if (source != null) {
            target.put(targetName, source);
        }
    }

    private static void putIfNotNullTS(Long source, Map<String, String> target, String targetName) {
        if (source != null) {
            target.put(targetName, String.valueOf(source));
        }
    }

    private static void putIfNotNullAsStringArray(String[] source, Map<String, String> target, String targetName) {
        if (source != null && source.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(source[0]);
            for (int i = 1; i < source.length; ++i) {
                sb.append("|").append(source[i]);
            }
            target.put(targetName, sb.toString());
        }
    }
}

