/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.index.reader.ChunkReader;
import org.apache.maven.index.reader.ResourceHandler;
import org.apache.maven.index.reader.Utils;
import org.apache.maven.index.reader.WritableResourceHandler;

public class IndexReader
implements Iterable<ChunkReader>,
Closeable {
    private final AtomicBoolean closed;
    private final WritableResourceHandler local;
    private final ResourceHandler remote;
    private final Properties localIndexProperties;
    private final Properties remoteIndexProperties;
    private final String indexId;
    private final Date publishedTimestamp;
    private final boolean incremental;
    private final List<String> chunkNames;

    public IndexReader(WritableResourceHandler local, ResourceHandler remote) throws IOException {
        Objects.requireNonNull(remote, "remote resource handler null");
        this.closed = new AtomicBoolean(false);
        this.local = local;
        this.remote = remote;
        this.remoteIndexProperties = Utils.loadProperties(remote.locate("nexus-maven-repository-index.properties"));
        if (this.remoteIndexProperties == null) {
            throw new IllegalArgumentException("Non-existent remote index");
        }
        try {
            if (local != null) {
                Properties localProperties = Utils.loadProperties(local.locate("nexus-maven-repository-index.properties"));
                if (localProperties != null) {
                    this.localIndexProperties = localProperties;
                    String remoteIndexId = this.remoteIndexProperties.getProperty("nexus.index.id");
                    String localIndexId = this.localIndexProperties.getProperty("nexus.index.id");
                    if (remoteIndexId == null || !remoteIndexId.equals(localIndexId)) {
                        throw new IllegalArgumentException("local and remote index IDs does not match or is null: " + localIndexId + ", " + remoteIndexId);
                    }
                    this.indexId = localIndexId;
                    this.incremental = this.canRetrieveAllChunks();
                } else {
                    this.localIndexProperties = null;
                    this.indexId = this.remoteIndexProperties.getProperty("nexus.index.id");
                    this.incremental = false;
                }
            } else {
                this.localIndexProperties = null;
                this.indexId = this.remoteIndexProperties.getProperty("nexus.index.id");
                this.incremental = false;
            }
            this.publishedTimestamp = Utils.INDEX_DATE_FORMAT.parse(this.remoteIndexProperties.getProperty("nexus.index.timestamp"));
            this.chunkNames = this.calculateChunkNames();
        }
        catch (ParseException e) {
            throw new IOException("Index properties corrupted", e);
        }
    }

    public String getIndexId() {
        return this.indexId;
    }

    public Date getPublishedTimestamp() {
        return this.publishedTimestamp;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public List<String> getChunkNames() {
        return this.chunkNames;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.remote.close();
            if (this.local != null) {
                try {
                    this.syncLocalWithRemote();
                }
                finally {
                    this.local.close();
                }
            }
        }
    }

    @Override
    public Iterator<ChunkReader> iterator() {
        return new ChunkReaderIterator(this.remote, this.chunkNames.iterator());
    }

    private void syncLocalWithRemote() throws IOException {
        Utils.storeProperties(this.local.locate("nexus-maven-repository-index.properties"), this.remoteIndexProperties);
    }

    private List<String> calculateChunkNames() {
        if (this.incremental) {
            ArrayList<CallSite> chunkNames = new ArrayList<CallSite>();
            int maxCounter = Integer.parseInt(this.remoteIndexProperties.getProperty("nexus.index.last-incremental"));
            int currentCounter = Integer.parseInt(this.localIndexProperties.getProperty("nexus.index.last-incremental"));
            ++currentCounter;
            while (currentCounter <= maxCounter) {
                chunkNames.add((CallSite)((Object)("nexus-maven-repository-index." + currentCounter++ + ".gz")));
            }
            return Collections.unmodifiableList(chunkNames);
        }
        return Collections.singletonList("nexus-maven-repository-index.gz");
    }

    private boolean canRetrieveAllChunks() {
        String localChainId = this.localIndexProperties.getProperty("nexus.index.chain-id");
        String remoteChainId = this.remoteIndexProperties.getProperty("nexus.index.chain-id");
        if (localChainId == null || !localChainId.equals(remoteChainId)) {
            return false;
        }
        try {
            int localLastIncremental = Integer.parseInt(this.localIndexProperties.getProperty("nexus.index.last-incremental"));
            String currentLocalCounter = String.valueOf(localLastIncremental);
            String nextLocalCounter = String.valueOf(localLastIncremental + 1);
            for (Object key : this.remoteIndexProperties.keySet()) {
                String value;
                String sKey = (String)key;
                if (!sKey.startsWith("nexus.index.incremental-") || !currentLocalCounter.equals(value = this.remoteIndexProperties.getProperty(sKey)) && !nextLocalCounter.equals(value)) continue;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private static class ChunkReaderIterator
    implements Iterator<ChunkReader> {
        private final ResourceHandler resourceHandler;
        private final Iterator<String> chunkNamesIterator;

        private ChunkReaderIterator(ResourceHandler resourceHandler, Iterator<String> chunkNamesIterator) {
            this.resourceHandler = resourceHandler;
            this.chunkNamesIterator = chunkNamesIterator;
        }

        @Override
        public boolean hasNext() {
            return this.chunkNamesIterator.hasNext();
        }

        @Override
        public ChunkReader next() {
            String chunkName = this.chunkNamesIterator.next();
            try {
                ResourceHandler.Resource currentResource = this.resourceHandler.locate(chunkName);
                return new ChunkReader(chunkName, currentResource.read());
            }
            catch (IOException e) {
                throw new UncheckedIOException("IO problem while opening chunk readers", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

