/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.maven.index.reader.ChunkWriter;
import org.apache.maven.index.reader.Utils;
import org.apache.maven.index.reader.WritableResourceHandler;

public class IndexWriter
implements Closeable {
    private static final int INDEX_V1 = 1;
    private final WritableResourceHandler local;
    private final Properties localIndexProperties;
    private final boolean incremental;
    private final String nextChunkCounter;
    private final String nextChunkName;

    public IndexWriter(WritableResourceHandler local, String indexId, boolean incrementalSupported) throws IOException {
        if (local == null) {
            throw new NullPointerException("local resource handler null");
        }
        if (indexId == null) {
            throw new NullPointerException("indexId null");
        }
        this.local = local;
        Properties indexProperties = Utils.loadProperties(local.locate("nexus-maven-repository-index.properties"));
        if (incrementalSupported && indexProperties != null) {
            this.localIndexProperties = indexProperties;
            String localIndexId = this.localIndexProperties.getProperty("nexus.index.id");
            if (localIndexId == null || !localIndexId.equals(indexId)) {
                throw new IllegalArgumentException("index already exists and indexId mismatch or unreadable: " + localIndexId + ", " + indexId);
            }
            this.incremental = true;
            this.nextChunkCounter = this.calculateNextChunkCounter();
            this.nextChunkName = "nexus-maven-repository-index." + this.nextChunkCounter + ".gz";
        } else {
            this.localIndexProperties = new Properties();
            this.localIndexProperties.setProperty("nexus.index.id", indexId);
            this.localIndexProperties.setProperty("nexus.index.chain-id", UUID.randomUUID().toString());
            this.incremental = false;
            this.nextChunkCounter = null;
            this.nextChunkName = "nexus-maven-repository-index.gz";
        }
    }

    public String getIndexId() {
        return this.localIndexProperties.getProperty("nexus.index.id");
    }

    public Date getPublishedTimestamp() {
        try {
            String timestamp = this.localIndexProperties.getProperty("nexus.index.timestamp");
            if (timestamp != null) {
                return Utils.INDEX_DATE_FORMAT.parse(timestamp);
            }
            return null;
        }
        catch (ParseException e) {
            throw new RuntimeException("Corrupt date", e);
        }
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public String getChainId() {
        return this.localIndexProperties.getProperty("nexus.index.chain-id");
    }

    public String getNextChunkName() {
        return this.nextChunkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeChunk(Iterator<Map<String, String>> iterator) throws IOException {
        try (WritableResourceHandler.WritableResource writableResource = this.local.locate(this.nextChunkName);){
            int written;
            try (ChunkWriter chunkWriter = new ChunkWriter(this.nextChunkName, writableResource.write(), 1, new Date());){
                written = chunkWriter.writeChunk(iterator);
            }
            if (this.incremental) {
                // empty if block
            }
            int n = written;
            return n;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.incremental) {
                this.localIndexProperties.setProperty("nexus.index.last-incremental", this.nextChunkCounter);
            }
            this.localIndexProperties.setProperty("nexus.index.timestamp", Utils.INDEX_DATE_FORMAT.format(new Date()));
            Utils.storeProperties(this.local.locate("nexus-maven-repository-index.properties"), this.localIndexProperties);
        }
        finally {
            this.local.close();
        }
    }

    private String calculateNextChunkCounter() {
        String lastChunkCounter = this.localIndexProperties.getProperty("nexus.index.last-incremental");
        if (lastChunkCounter != null) {
            return String.valueOf(Integer.parseInt(lastChunkCounter) + 1);
        }
        return "1";
    }
}

