/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class ChunkReader
implements Closeable,
Iterable<Map<String, String>> {
    private final String chunkName;
    private final DataInputStream dataInputStream;
    private final int version;
    private final Date timestamp;

    public ChunkReader(String chunkName, InputStream inputStream) throws IOException {
        this.chunkName = chunkName.trim();
        this.dataInputStream = new DataInputStream(new GZIPInputStream(inputStream, 2048));
        this.version = this.dataInputStream.readByte() & 0xFF;
        this.timestamp = new Date(this.dataInputStream.readLong());
    }

    public String getName() {
        return this.chunkName;
    }

    public int getVersion() {
        return this.version;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        try {
            return new IndexIterator(this.dataInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("error", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.dataInputStream.close();
    }

    private static Map<String, String> readRecord(DataInput dataInput) throws IOException {
        int fieldCount;
        try {
            fieldCount = dataInput.readInt();
        }
        catch (EOFException ex) {
            return null;
        }
        HashMap<String, String> recordMap = new HashMap<String, String>();
        for (int i = 0; i < fieldCount; ++i) {
            ChunkReader.readField(recordMap, dataInput);
        }
        return recordMap;
    }

    private static void readField(Map<String, String> record, DataInput dataInput) throws IOException {
        dataInput.readByte();
        String name = dataInput.readUTF();
        String value = ChunkReader.readUTF(dataInput);
        record.put(name, value);
    }

    private static String readUTF(DataInput dataInput) throws IOException {
        int c;
        int count;
        char[] chararr;
        byte[] bytearr;
        int utflen = dataInput.readInt();
        try {
            bytearr = new byte[utflen];
            chararr = new char[utflen];
        }
        catch (OutOfMemoryError e) {
            IOException ioex = new IOException("Index data content is corrupt");
            ioex.initCause(e);
            throw ioex;
        }
        int chararrCount = 0;
        dataInput.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block8: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block8;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block8;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block8;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }

    private static class IndexIterator
    implements Iterator<Map<String, String>> {
        private final DataInputStream dataInputStream;
        private Map<String, String> nextRecord;

        private IndexIterator(DataInputStream dataInputStream) throws IOException {
            this.dataInputStream = dataInputStream;
            this.nextRecord = this.nextRecord();
        }

        @Override
        public boolean hasNext() {
            return this.nextRecord != null;
        }

        @Override
        public Map<String, String> next() {
            if (this.nextRecord == null) {
                throw new NoSuchElementException("chunk depleted");
            }
            Map<String, String> result = this.nextRecord;
            this.nextRecord = this.nextRecord();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private Map<String, String> nextRecord() {
            try {
                return ChunkReader.readRecord(this.dataInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("read error", e);
            }
        }
    }
}

