/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.Transform;
import org.apache.maven.index.reader.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordExpander
implements Transform.Function<Map<String, String>, Record> {
    @Override
    public Record apply(Map<String, String> recordMap) {
        String[] splitInfo;
        if (recordMap.containsKey("DESCRIPTOR")) {
            return RecordExpander.expandDescriptor(recordMap);
        }
        if (recordMap.containsKey("allGroups")) {
            return RecordExpander.expandAllGroups(recordMap);
        }
        if (recordMap.containsKey("rootGroups")) {
            return RecordExpander.expandRootGroups(recordMap);
        }
        if (recordMap.containsKey("del")) {
            return RecordExpander.expandDeletedArtifact(recordMap);
        }
        String uinfo = recordMap.get("u");
        String info = recordMap.get("i");
        if (uinfo != null && info != null && info.trim().length() != 0 && (splitInfo = Utils.FS_PATTERN.split(info)).length > 6) {
            String extension = splitInfo[6];
            if (uinfo.endsWith("|NA")) {
                recordMap.put("u", uinfo + "|" + extension);
            }
        }
        return RecordExpander.expandAddedArtifact(recordMap);
    }

    private static Record expandDescriptor(Map<String, String> raw) {
        Record result = new Record(Record.Type.DESCRIPTOR, new HashMap<Record.EntryKey, Object>());
        String[] r = Utils.FS_PATTERN.split(raw.get("IDXINFO"));
        result.put(Record.REPOSITORY_ID, r[1]);
        return result;
    }

    private static Record expandAllGroups(Map<String, String> raw) {
        Record result = new Record(Record.Type.ALL_GROUPS, new HashMap<Record.EntryKey, Object>());
        RecordExpander.putIfNotNullAsStringArray(raw, "allGroupsList", result, Record.ALL_GROUPS);
        return result;
    }

    private static Record expandRootGroups(Map<String, String> raw) {
        Record result = new Record(Record.Type.ROOT_GROUPS, new HashMap<Record.EntryKey, Object>());
        RecordExpander.putIfNotNullAsStringArray(raw, "rootGroupsList", result, Record.ROOT_GROUPS);
        return result;
    }

    private static Record expandDeletedArtifact(Map<String, String> raw) {
        Record result = new Record(Record.Type.ARTIFACT_REMOVE, new HashMap<Record.EntryKey, Object>());
        RecordExpander.putIfNotNullTS(raw, "m", result, Record.REC_MODIFIED);
        if (raw.containsKey("del")) {
            RecordExpander.expandUinfo(raw.get("del"), result);
        }
        return result;
    }

    private static Record expandAddedArtifact(Map<String, String> raw) {
        Record result = new Record(Record.Type.ARTIFACT_ADD, new HashMap<Record.EntryKey, Object>());
        RecordExpander.expandUinfo(raw.get("u"), result);
        String info = raw.get("i");
        if (info != null) {
            String[] r = Utils.FS_PATTERN.split(info);
            result.put(Record.PACKAGING, Utils.renvl(r[0]));
            result.put(Record.FILE_MODIFIED, Long.valueOf(r[1]));
            result.put(Record.FILE_SIZE, Long.valueOf(r[2]));
            result.put(Record.HAS_SOURCES, "1".equals(r[3]) ? Boolean.TRUE : Boolean.FALSE);
            result.put(Record.HAS_JAVADOC, "1".equals(r[4]) ? Boolean.TRUE : Boolean.FALSE);
            result.put(Record.HAS_SIGNATURE, "1".equals(r[5]) ? Boolean.TRUE : Boolean.FALSE);
            if (r.length > 6) {
                result.put(Record.FILE_EXTENSION, r[6]);
            } else {
                String packaging = Record.PACKAGING.coerce(result.get(Record.PACKAGING));
                if (result.containsKey(Record.CLASSIFIER) || "pom".equals(packaging) || "war".equals(packaging) || "ear".equals(packaging)) {
                    result.put(Record.FILE_EXTENSION, packaging);
                } else {
                    result.put(Record.FILE_EXTENSION, "jar");
                }
            }
        }
        RecordExpander.putIfNotNullTS(raw, "m", result, Record.REC_MODIFIED);
        RecordExpander.putIfNotNull(raw, "n", result, Record.NAME);
        RecordExpander.putIfNotNull(raw, "d", result, Record.DESCRIPTION);
        RecordExpander.putIfNotNull(raw, "1", result, Record.SHA1);
        RecordExpander.putIfNotNullAsStringArray(raw, "classnames", result, Record.CLASSNAMES);
        RecordExpander.putIfNotNull(raw, "px", result, Record.PLUGIN_PREFIX);
        RecordExpander.putIfNotNullAsStringArray(raw, "gx", result, Record.PLUGIN_GOALS);
        RecordExpander.putIfNotNull(raw, "Bundle-SymbolicName", result, Record.OSGI_BUNDLE_SYMBOLIC_NAME);
        RecordExpander.putIfNotNull(raw, "Bundle-Version", result, Record.OSGI_BUNDLE_VERSION);
        RecordExpander.putIfNotNull(raw, "Export-Package", result, Record.OSGI_EXPORT_PACKAGE);
        RecordExpander.putIfNotNull(raw, "Export-Service", result, Record.OSGI_EXPORT_SERVICE);
        RecordExpander.putIfNotNull(raw, "Bundle-Description", result, Record.OSGI_BUNDLE_DESCRIPTION);
        RecordExpander.putIfNotNull(raw, "Bundle-Name", result, Record.OSGI_BUNDLE_NAME);
        RecordExpander.putIfNotNull(raw, "Bundle-License", result, Record.OSGI_BUNDLE_LICENSE);
        RecordExpander.putIfNotNull(raw, "Bundle-DocURL", result, Record.OSGI_EXPORT_DOCURL);
        RecordExpander.putIfNotNull(raw, "Import-Package", result, Record.OSGI_IMPORT_PACKAGE);
        RecordExpander.putIfNotNull(raw, "Require-Bundle", result, Record.OSGI_REQUIRE_BUNDLE);
        return result;
    }

    private static void expandUinfo(String uinfo, Record result) {
        if (uinfo != null) {
            String[] r = Utils.FS_PATTERN.split(uinfo);
            result.put(Record.GROUP_ID, r[0]);
            result.put(Record.ARTIFACT_ID, r[1]);
            result.put(Record.VERSION, r[2]);
            String classifier = Utils.renvl(r[3]);
            if (classifier != null) {
                result.put(Record.CLASSIFIER, classifier);
                if (r.length > 4) {
                    result.put(Record.FILE_EXTENSION, r[4]);
                }
            } else if (r.length > 4) {
                result.put(Record.PACKAGING, r[4]);
            }
        }
    }

    private static void putIfNotNull(Map<String, String> source, String sourceName, Record target, Record.EntryKey targetName) {
        String value = source.get(sourceName);
        if (value != null && value.trim().length() != 0) {
            target.put(targetName, value);
        }
    }

    private static void putIfNotNullTS(Map<String, String> source, String sourceName, Record target, Record.EntryKey targetName) {
        String value = source.get(sourceName);
        if (value != null && value.trim().length() != 0) {
            target.put(targetName, Long.valueOf(value));
        }
    }

    private static void putIfNotNullAsStringArray(Map<String, String> source, String sourceName, Record target, Record.EntryKey targetName) {
        String value = source.get(sourceName);
        if (value != null && value.trim().length() != 0) {
            target.put(targetName, Utils.FS_PATTERN.split(value));
        }
    }
}

