/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.indexer.examples.indexing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryIndexer.class);
    private static final String[] LUCENE_FIELDS = new String[]{"g", "a", "v", "p", "c"};
    private static final WhitespaceAnalyzer LUCENE_ANALYZER = new WhitespaceAnalyzer();
    private Indexer indexer;
    private Scanner scanner;
    private List<IndexCreator> indexers;
    private IndexingContext indexingContext;
    private String repositoryId;
    private File repositoryBasedir;
    private File indexDir;

    public void close() throws IOException {
        this.indexer.closeIndexingContext(this.indexingContext, false);
    }

    public void close(boolean deleteFiles) throws IOException {
        this.indexingContext.close(deleteFiles);
    }

    public void delete(Collection<ArtifactInfo> artifacts) throws IOException {
        ArrayList<ArtifactContext> delete = new ArrayList<ArtifactContext>();
        for (ArtifactInfo artifact : artifacts) {
            LOGGER.debug("Deleting artifact: {}; ctx id: {}; idx dir: {}", (Object[])new String[]{artifact.toString(), this.indexingContext.getId(), this.indexingContext.getIndexDirectory().toString()});
            delete.add(new ArtifactContext(null, null, null, artifact, null));
        }
        this.getIndexer().deleteArtifactsFromIndex(delete, this.indexingContext);
    }

    public Set<ArtifactInfo> search(String groupId, String artifactId, String version, String packaging, String classifier) throws IOException {
        BooleanQuery query = new BooleanQuery();
        if (groupId != null) {
            query.add(this.getIndexer().constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression(groupId)), BooleanClause.Occur.MUST);
        }
        if (artifactId != null) {
            query.add(this.getIndexer().constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression(artifactId)), BooleanClause.Occur.MUST);
        }
        if (version != null) {
            query.add(this.getIndexer().constructQuery(MAVEN.VERSION, (SearchExpression)new SourcedSearchExpression(version)), BooleanClause.Occur.MUST);
        }
        if (packaging != null) {
            query.add(this.getIndexer().constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression(packaging)), BooleanClause.Occur.MUST);
        } else {
            query.add(this.getIndexer().constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("jar")), BooleanClause.Occur.MUST);
        }
        if (classifier != null) {
            query.add(this.getIndexer().constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression(classifier)), BooleanClause.Occur.MUST);
        }
        LOGGER.debug("Executing search query: {}; ctx id: {}; idx dir: {}", (Object[])new String[]{query.toString(), this.indexingContext.getId(), this.indexingContext.getIndexDirectory().toString()});
        FlatSearchResponse response = this.getIndexer().searchFlat(new FlatSearchRequest((Query)query, this.indexingContext));
        LOGGER.info("Hit count: {}", (Object)response.getReturnedHitsCount());
        Set results = response.getResults();
        if (LOGGER.isDebugEnabled()) {
            for (ArtifactInfo result : results) {
                LOGGER.debug("Found artifact: {}", (Object)result.toString());
            }
        }
        return results;
    }

    public Set<ArtifactInfo> search(String queryText) throws ParseException, IOException {
        Query query = new MultiFieldQueryParser(LUCENE_FIELDS, (Analyzer)LUCENE_ANALYZER).parse(queryText);
        LOGGER.debug("Executing search query: {}; ctx id: {}; idx dir: {}", (Object[])new String[]{query.toString(), this.indexingContext.getId(), this.indexingContext.getIndexDirectory().toString()});
        FlatSearchResponse response = this.getIndexer().searchFlat(new FlatSearchRequest(query, this.indexingContext));
        Set results = response.getResults();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Hit count: {}", (Object)response.getReturnedHitsCount());
            for (ArtifactInfo result : results) {
                LOGGER.debug("Found artifact: {}; uinfo: {}", (Object)result.toString(), (Object)result.getUinfo());
            }
        }
        return results;
    }

    public Set<ArtifactInfo> searchBySHA1(String checksum) throws IOException {
        BooleanQuery query = new BooleanQuery();
        query.add(this.getIndexer().constructQuery(MAVEN.SHA1, (SearchExpression)new SourcedSearchExpression(checksum)), BooleanClause.Occur.MUST);
        LOGGER.debug("Executing search query: {}; ctx id: {}; idx dir: {}", (Object[])new String[]{query.toString(), this.indexingContext.getId(), this.indexingContext.getIndexDirectory().toString()});
        FlatSearchResponse response = this.getIndexer().searchFlat(new FlatSearchRequest((Query)query, this.indexingContext));
        LOGGER.info("Hit count: {}", (Object)response.getReturnedHitsCount());
        Set results = response.getResults();
        if (LOGGER.isDebugEnabled()) {
            for (ArtifactInfo result : results) {
                LOGGER.debug("Found artifact: {}", (Object)result.toString());
            }
        }
        return results;
    }

    public int index(File startingPath) {
        ScanningResult scan = this.getScanner().scan(new ScanningRequest(this.indexingContext, (ArtifactScanningListener)new ReindexArtifactScanningListener(), startingPath == null ? "." : startingPath.getPath()));
        return scan.getTotalFiles();
    }

    public void addArtifactToIndex(File artifactFile, ArtifactInfo artifactInfo) throws IOException {
        this.getIndexer().addArtifactsToIndex(Arrays.asList(new ArtifactContext(null, artifactFile, null, artifactInfo, null)), this.indexingContext);
    }

    public void addArtifactToIndex(String repository, File artifactFile, String groupId, String artifactId, String version, String extension, String classifier) throws IOException {
        ArtifactInfo artifactInfo = new ArtifactInfo(repository, groupId, artifactId, version, classifier, extension);
        if (extension != null) {
            artifactInfo.setFieldValue(MAVEN.EXTENSION, extension);
        }
        LOGGER.debug("Adding artifact: {}; repo: {}; type: {}", (Object[])new String[]{artifactInfo.getUinfo(), repository, extension});
        this.getIndexer().addArtifactsToIndex(Arrays.asList(new ArtifactContext(null, artifactFile, null, artifactInfo, artifactInfo.calculateGav())), this.indexingContext);
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public void setScanner(Scanner scanner) {
        this.scanner = scanner;
    }

    public List<IndexCreator> getIndexers() {
        return this.indexers;
    }

    public void setIndexers(List<IndexCreator> indexers) {
        this.indexers = indexers;
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    public void setIndexingContext(IndexingContext indexingContext) {
        this.indexingContext = indexingContext;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public File getRepositoryBasedir() {
        return this.repositoryBasedir;
    }

    public void setRepositoryBasedir(File repositoryBasedir) {
        this.repositoryBasedir = repositoryBasedir;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(File indexDir) {
        this.indexDir = indexDir;
    }

    private class ReindexArtifactScanningListener
    implements ArtifactScanningListener {
        int totalFiles = 0;
        private IndexingContext context;

        private ReindexArtifactScanningListener() {
        }

        public void scanningStarted(IndexingContext context) {
            this.context = context;
        }

        public void scanningFinished(IndexingContext context, ScanningResult result) {
            result.setTotalFiles(this.totalFiles);
            LOGGER.debug("Scanning finished; total files: {}; has exception: {}", (Object)result.getTotalFiles(), (Object)result.hasExceptions());
        }

        public void artifactError(ArtifactContext ac, Exception ex) {
            LOGGER.error("Artifact error!", (Throwable)ex);
        }

        public void artifactDiscovered(ArtifactContext ac) {
            try {
                LOGGER.debug("Adding artifact gav: {}; ctx id: {}; idx dir: {}", (Object[])new String[]{ac.getGav().toString(), this.context.getId(), this.context.getIndexDirectory().toString()});
                RepositoryIndexer.this.getIndexer().addArtifactsToIndex(Arrays.asList(ac), this.context);
                ++this.totalFiles;
            }
            catch (IOException ex) {
                LOGGER.error("Artifact index error", (Throwable)ex);
            }
        }
    }
}

