/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.indexer.examples.indexing;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.indexer.examples.indexing.IndexerConfiguration;
import org.apache.maven.indexer.examples.indexing.RepositoryIndexer;

@Singleton
public class RepositoryIndexerFactory {
    private IndexerConfiguration indexerConfiguration;

    @Inject
    public RepositoryIndexerFactory(IndexerConfiguration indexerConfiguration) {
        this.indexerConfiguration = indexerConfiguration;
    }

    public RepositoryIndexer createRepositoryIndexer(String repositoryId, File repositoryBasedir, File indexDir) throws IOException {
        RepositoryIndexer repositoryIndexer = new RepositoryIndexer();
        repositoryIndexer.setRepositoryId(repositoryId);
        repositoryIndexer.setRepositoryBasedir(repositoryBasedir);
        repositoryIndexer.setIndexDir(indexDir);
        repositoryIndexer.setIndexingContext(this.createIndexingContext(repositoryId, repositoryBasedir, indexDir));
        repositoryIndexer.setIndexer(this.indexerConfiguration.getIndexer());
        repositoryIndexer.setScanner(this.indexerConfiguration.getScanner());
        return repositoryIndexer;
    }

    private IndexingContext createIndexingContext(String repositoryId, File repositoryBasedir, File indexDir) throws IOException {
        return this.getIndexer().createIndexingContext(repositoryId + "/ctx", repositoryId, repositoryBasedir, indexDir, null, null, true, true, this.indexerConfiguration.getIndexersAsList());
    }

    public IndexerConfiguration getIndexerConfiguration() {
        return this.indexerConfiguration;
    }

    public void setIndexerConfiguration(IndexerConfiguration indexerConfiguration) {
        this.indexerConfiguration = indexerConfiguration;
    }

    public Indexer getIndexer() {
        return this.indexerConfiguration.getIndexer();
    }

    public Scanner getScanner() {
        return this.indexerConfiguration.getScanner();
    }

    public Map<String, IndexCreator> getIndexers() {
        return this.indexerConfiguration.getIndexers();
    }
}

