/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.examples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.expr.UserInputSearchExpression;
import org.apache.maven.index.search.grouping.GAGrouping;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

@Singleton
@Named
public class BasicUsageExample {
    private final Indexer indexer;
    private final IndexUpdater indexUpdater;
    private final Map<String, IndexCreator> indexCreators;
    private IndexingContext centralContext;
    private static final int MAX_WIDTH = 60;

    @Inject
    public BasicUsageExample(Indexer indexer, IndexUpdater indexUpdater, Map<String, IndexCreator> indexCreators) {
        this.indexer = Objects.requireNonNull(indexer);
        this.indexUpdater = Objects.requireNonNull(indexUpdater);
        this.indexCreators = Objects.requireNonNull(indexCreators);
    }

    public void perform() throws IOException, InvalidVersionSpecificationException {
        File centralLocalCache = new File("target/central-cache");
        File centralIndexDir = new File("target/central-index");
        ArrayList<IndexCreator> indexers = new ArrayList<IndexCreator>();
        indexers.add(Objects.requireNonNull(this.indexCreators.get("min")));
        indexers.add(Objects.requireNonNull(this.indexCreators.get("jarContent")));
        indexers.add(Objects.requireNonNull(this.indexCreators.get("maven-plugin")));
        this.centralContext = this.indexer.createIndexingContext("central-context", "central", centralLocalCache, centralIndexDir, "https://repo1.maven.org/maven2", null, true, true, indexers);
        Instant updateStart = Instant.now();
        System.out.println("Updating Index...");
        System.out.println("This might take a while on first run, so please be patient!");
        Date centralContextCurrentTimestamp = this.centralContext.getTimestamp();
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.centralContext, (ResourceFetcher)new Java11HttpClient());
        IndexUpdateResult updateResult = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            System.out.println("Full update happened!");
        } else if (updateResult.getTimestamp().equals(centralContextCurrentTimestamp)) {
            System.out.println("No update needed, index is up to date!");
        } else {
            System.out.println("Incremental update happened, change covered " + centralContextCurrentTimestamp + " - " + updateResult.getTimestamp() + " period.");
        }
        System.out.println("Finished in " + Duration.between(updateStart, Instant.now()).getSeconds() + " sec");
        System.out.println();
        System.out.println();
        System.out.println("Using index");
        System.out.println("===========");
        System.out.println();
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        String versionString = "3.1.0";
        Version version = versionScheme.parseVersion("3.1.0");
        Query groupIdQ = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("org.apache.maven"));
        Query artifactIdQ = this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression("maven-plugin-api"));
        BooleanQuery query = new BooleanQuery.Builder().add(groupIdQ, BooleanClause.Occur.MUST).add(artifactIdQ, BooleanClause.Occur.MUST).add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("jar")), BooleanClause.Occur.MUST).add(this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression("N/P")), BooleanClause.Occur.MUST_NOT).build();
        ArtifactInfoFilter versionFilter = (ctx, ai) -> {
            try {
                Version aiV = versionScheme.parseVersion(ai.getVersion());
                return aiV.compareTo((Object)version) > 0;
            }
            catch (InvalidVersionSpecificationException e) {
                return true;
            }
        };
        System.out.println("Searching for all GAVs with org.apache.maven:maven-plugin-api having V greater than 3.1.0");
        IteratorSearchRequest request = new IteratorSearchRequest((Query)query, Collections.singletonList(this.centralContext), versionFilter);
        IteratorSearchResponse response = this.indexer.searchIterator(request);
        for (ArtifactInfo ai2 : response) {
            System.out.println(ai2.toString());
        }
        Query gidQ = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("org.apache.maven.indexer"));
        Query aidQ = this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression("indexer-core"));
        BooleanQuery bq = new BooleanQuery.Builder().add(gidQ, BooleanClause.Occur.MUST).add(aidQ, BooleanClause.Occur.MUST).build();
        this.searchAndDump(this.indexer, "all artifacts under GA org.apache.maven.indexer:indexer-core", (Query)bq);
        bq = new BooleanQuery.Builder().add(gidQ, BooleanClause.Occur.MUST).add(aidQ, BooleanClause.Occur.MUST).add(this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression("*")), BooleanClause.Occur.MUST_NOT).build();
        this.searchAndDump(this.indexer, "main artifacts under GA org.apache.maven.indexer:indexer-core", (Query)bq);
        this.searchAndDump(this.indexer, "SHA1 7ab67e6b20e5332a7fb4fdf2f019aec4275846c2", this.indexer.constructQuery(MAVEN.SHA1, (SearchExpression)new SourcedSearchExpression("7ab67e6b20e5332a7fb4fdf2f019aec4275846c2")));
        this.searchAndDump(this.indexer, "SHA1 7ab67e6b20 (partial hash)", this.indexer.constructQuery(MAVEN.SHA1, (SearchExpression)new UserInputSearchExpression("7ab67e6b20")));
        this.searchAndDump(this.indexer, "classname DefaultNexusIndexer (note: Central does not publish classes in the index)", this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression("DefaultNexusIndexer")));
        bq = new BooleanQuery.Builder().add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("maven-plugin")), BooleanClause.Occur.MUST).add(this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("org.apache.maven.plugins")), BooleanClause.Occur.MUST).build();
        this.searchGroupedAndDumpFlat(this.indexer, "all \"canonical\" maven plugins", (Query)bq, (Grouping)new GAGrouping());
        this.searchGroupedAndDump(this.indexer, "all maven archetypes (latest versions)", this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("maven-archetype")), (Grouping)new GAGrouping());
        this.indexer.closeIndexingContext(this.centralContext, false);
    }

    public void searchAndDump(Indexer nexusIndexer, String descr, Query q) throws IOException {
        System.out.println("Searching for " + descr);
        FlatSearchResponse response = nexusIndexer.searchFlat(new FlatSearchRequest(q, this.centralContext));
        for (ArtifactInfo ai : response.getResults()) {
            System.out.println(ai.toString());
        }
        System.out.println("------");
        System.out.println("Total: " + response.getTotalHitsCount());
        System.out.println();
    }

    public void searchGroupedAndDumpFlat(Indexer nexusIndexer, String descr, Query q, Grouping g) throws IOException {
        System.out.println("Searching for " + descr);
        GroupedSearchResponse response = nexusIndexer.searchGrouped(new GroupedSearchRequest(q, g, this.centralContext));
        for (Map.Entry entry : response.getResults().entrySet()) {
            ArtifactInfo ai = (ArtifactInfo)((ArtifactInfoGroup)entry.getValue()).getArtifactInfos().iterator().next();
            System.out.println("* " + ai.getGroupId() + ":" + ai.getArtifactId() + ":" + ai.getVersion());
        }
        System.out.println("------");
        System.out.println("Total record hits: " + response.getTotalHitsCount());
        System.out.println();
    }

    public void searchGroupedAndDump(Indexer nexusIndexer, String descr, Query q, Grouping g) throws IOException {
        System.out.println("Searching for " + descr);
        GroupedSearchResponse response = nexusIndexer.searchGrouped(new GroupedSearchRequest(q, g, this.centralContext));
        for (Map.Entry entry : response.getResults().entrySet()) {
            ArtifactInfo ai = (ArtifactInfo)((ArtifactInfoGroup)entry.getValue()).getArtifactInfos().iterator().next();
            System.out.println("* Entry " + ai);
            System.out.println("  Latest version:  " + ai.getVersion());
            System.out.println(StringUtils.isBlank((String)ai.getDescription()) ? "No description in plugin's POM." : StringUtils.abbreviate((String)ai.getDescription(), (int)60));
            System.out.println();
        }
        System.out.println("------");
        System.out.println("Total record hits: " + response.getTotalHitsCount());
        System.out.println();
    }

    private static class Java11HttpClient
    implements ResourceFetcher {
        private final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).build();
        private URI uri;

        private Java11HttpClient() {
        }

        public void connect(String id, String url) throws IOException {
            this.uri = URI.create(url + "/");
        }

        public void disconnect() throws IOException {
        }

        public InputStream retrieve(String name) throws IOException, FileNotFoundException {
            HttpRequest request = HttpRequest.newBuilder().uri(this.uri.resolve(name)).GET().build();
            try {
                HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                if (response.statusCode() == 200) {
                    return response.body();
                }
                throw new IOException("Unexpected response: " + response);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
    }
}

