/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.indexer.examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfoGroup;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.GroupedSearchRequest;
import org.apache.maven.index.GroupedSearchResponse;
import org.apache.maven.index.Grouping;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SearchExpression;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.expr.UserInputSearchExpression;
import org.apache.maven.index.search.grouping.GAGrouping;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.AbstractTransferListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;

public class BasicUsageExample {
    private final PlexusContainer plexusContainer;
    private final Indexer indexer;
    private final IndexUpdater indexUpdater;
    private final Wagon httpWagon;
    private IndexingContext centralContext;
    private static final int MAX_WIDTH = 60;

    public static void main(String[] args) throws Exception {
        BasicUsageExample basicUsageExample = new BasicUsageExample();
        basicUsageExample.perform();
    }

    public BasicUsageExample() throws PlexusContainerException, ComponentLookupException {
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("index");
        this.plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        this.indexer = (Indexer)this.plexusContainer.lookup(Indexer.class);
        this.indexUpdater = (IndexUpdater)this.plexusContainer.lookup(IndexUpdater.class);
        this.httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
    }

    public void perform() throws IOException, ComponentLookupException, InvalidVersionSpecificationException {
        File centralLocalCache = new File("target/central-cache");
        File centralIndexDir = new File("target/central-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "min"));
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "jarContent"));
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "maven-plugin"));
        this.centralContext = this.indexer.createIndexingContext("central-context", "central", centralLocalCache, centralIndexDir, "http://repo1.maven.org/maven2", null, true, true, indexers);
        System.out.println("Updating Index...");
        System.out.println("This might take a while on first run, so please be patient!");
        AbstractTransferListener listener = new AbstractTransferListener(){

            public void transferStarted(TransferEvent transferEvent) {
                System.out.print("  Downloading " + transferEvent.getResource().getName());
            }

            public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
            }

            public void transferCompleted(TransferEvent transferEvent) {
                System.out.println(" - Done");
            }
        };
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(this.httpWagon, (TransferListener)listener, null, null);
        Date centralContextCurrentTimestamp = this.centralContext.getTimestamp();
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.centralContext, (ResourceFetcher)resourceFetcher);
        IndexUpdateResult updateResult = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            System.out.println("Full update happened!");
        } else if (updateResult.getTimestamp().equals(centralContextCurrentTimestamp)) {
            System.out.println("No update needed, index is up to date!");
        } else {
            System.out.println("Incremental update happened, change covered " + centralContextCurrentTimestamp + " - " + updateResult.getTimestamp() + " period.");
        }
        System.out.println();
        System.out.println();
        System.out.println("Using index");
        System.out.println("===========");
        System.out.println();
        final GenericVersionScheme versionScheme = new GenericVersionScheme();
        String versionString = "1.5.0";
        final Version version = versionScheme.parseVersion("1.5.0");
        Query groupIdQ = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("org.sonatype.nexus"));
        Query artifactIdQ = this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression("nexus-api"));
        BooleanQuery query = new BooleanQuery();
        query.add(groupIdQ, BooleanClause.Occur.MUST);
        query.add(artifactIdQ, BooleanClause.Occur.MUST);
        query.add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("jar")), BooleanClause.Occur.MUST);
        query.add(this.indexer.constructQuery(MAVEN.CLASSIFIER, (SearchExpression)new SourcedSearchExpression("N/P")), BooleanClause.Occur.MUST_NOT);
        ArtifactInfoFilter versionFilter = new ArtifactInfoFilter(){

            public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
                try {
                    Version aiV = versionScheme.parseVersion(ai.getVersion());
                    return aiV.compareTo((Object)version) > 0;
                }
                catch (InvalidVersionSpecificationException e) {
                    return true;
                }
            }
        };
        System.out.println("Searching for all GAVs with G=org.sonatype.nexus and nexus-api and having V greater than 1.5.0");
        IteratorSearchRequest request = new IteratorSearchRequest((Query)query, Collections.singletonList(this.centralContext), versionFilter);
        IteratorSearchResponse response = this.indexer.searchIterator(request);
        for (ArtifactInfo ai : response) {
            System.out.println(ai.toString());
        }
        Query gidQ = this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("org.apache.maven.indexer"));
        Query aidQ = this.indexer.constructQuery(MAVEN.ARTIFACT_ID, (SearchExpression)new SourcedSearchExpression("indexer-artifact"));
        BooleanQuery bq = new BooleanQuery();
        bq.add(gidQ, BooleanClause.Occur.MUST);
        bq.add(aidQ, BooleanClause.Occur.MUST);
        this.searchAndDump(this.indexer, "all artifacts under GA org.apache.maven.indexer:indexer-artifact", (Query)bq);
        bq = new BooleanQuery();
        bq.add(gidQ, BooleanClause.Occur.MUST);
        bq.add(aidQ, BooleanClause.Occur.MUST);
        this.searchAndDump(this.indexer, "main artifacts under GA org.apache.maven.indexer:indexer-artifact", (Query)bq);
        this.searchAndDump(this.indexer, "SHA1 7ab67e6b20e5332a7fb4fdf2f019aec4275846c2", this.indexer.constructQuery(MAVEN.SHA1, (SearchExpression)new SourcedSearchExpression("7ab67e6b20e5332a7fb4fdf2f019aec4275846c2")));
        this.searchAndDump(this.indexer, "SHA1 7ab67e6b20 (partial hash)", this.indexer.constructQuery(MAVEN.SHA1, (SearchExpression)new UserInputSearchExpression("7ab67e6b20")));
        this.searchAndDump(this.indexer, "classname DefaultNexusIndexer (note: Central does not publish classes in the index)", this.indexer.constructQuery(MAVEN.CLASSNAMES, (SearchExpression)new UserInputSearchExpression("DefaultNexusIndexer")));
        bq = new BooleanQuery();
        bq.add(this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("maven-plugin")), BooleanClause.Occur.MUST);
        bq.add(this.indexer.constructQuery(MAVEN.GROUP_ID, (SearchExpression)new SourcedSearchExpression("org.apache.maven.plugins")), BooleanClause.Occur.MUST);
        this.searchGroupedAndDump(this.indexer, "all \"canonical\" maven plugins", (Query)bq, (Grouping)new GAGrouping());
        this.searchGroupedAndDump(this.indexer, "all maven archetypes (latest versions)", this.indexer.constructQuery(MAVEN.PACKAGING, (SearchExpression)new SourcedSearchExpression("maven-archetype")), (Grouping)new GAGrouping());
        this.indexer.closeIndexingContext(this.centralContext, false);
    }

    public void searchAndDump(Indexer nexusIndexer, String descr, Query q) throws IOException {
        System.out.println("Searching for " + descr);
        FlatSearchResponse response = nexusIndexer.searchFlat(new FlatSearchRequest(q, this.centralContext));
        for (ArtifactInfo ai : response.getResults()) {
            System.out.println(ai.toString());
        }
        System.out.println("------");
        System.out.println("Total: " + response.getTotalHitsCount());
        System.out.println();
    }

    public void searchGroupedAndDump(Indexer nexusIndexer, String descr, Query q, Grouping g) throws IOException {
        System.out.println("Searching for " + descr);
        GroupedSearchResponse response = nexusIndexer.searchGrouped(new GroupedSearchRequest(q, g, this.centralContext));
        for (Map.Entry entry : response.getResults().entrySet()) {
            ArtifactInfo ai = (ArtifactInfo)((ArtifactInfoGroup)entry.getValue()).getArtifactInfos().iterator().next();
            System.out.println("* Entry " + ai);
            System.out.println("  Latest version:  " + ai.getVersion());
            System.out.println(StringUtils.isBlank((String)ai.getDescription()) ? "No description in plugin's POM." : StringUtils.abbreviate((String)ai.getDescription(), (int)60));
            System.out.println();
        }
        System.out.println("------");
        System.out.println("Total record hits: " + response.getTotalHitsCount());
        System.out.println();
    }
}

