/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.cli;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.cli.Components;
import org.apache.maven.index.cli.PartialImplementation;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.apache.maven.index.updater.DefaultIndexUpdater;
import org.eclipse.sisu.launch.Main;
import org.eclipse.sisu.space.BeanScanning;

public class NexusIndexerCli {
    public static final String QUIET = "q";
    public static final String DEBUG = "X";
    public static final String HELP = "h";
    public static final String VERSION = "v";
    public static final String REPO = "r";
    public static final String INDEX = "i";
    public static final String NAME = "n";
    public static final String TYPE = "t";
    public static final String TARGET_DIR = "d";
    public static final String CREATE_INCREMENTAL_CHUNKS = "c";
    public static final String CREATE_FILE_CHECKSUMS = "s";
    public static final String INCREMENTAL_CHUNK_KEEP_COUNT = "k";
    public static final String UNPACK = "u";
    private static final long MB = 0x100000L;
    private Options options;

    public static void main(String[] args) {
        System.exit(new NexusIndexerCli().execute(args));
    }

    int execute(String[] args) {
        CommandLine cli;
        try {
            cli = new DefaultParser().parse(this.buildCliOptions(), this.cleanArgs(args));
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            this.displayHelp();
            return 1;
        }
        boolean debug = cli.hasOption(DEBUG);
        if (cli.hasOption(HELP)) {
            this.displayHelp();
            return 0;
        }
        if (cli.hasOption(VERSION)) {
            this.showVersion();
            return 0;
        }
        if (debug) {
            this.showVersion();
        }
        Module app = Main.wire((BeanScanning)BeanScanning.INDEX, (Module[])new Module[0]);
        Components components = (Components)Guice.createInjector((Module[])new Module[]{app}).getInstance(Components.class);
        if (cli.hasOption(UNPACK)) {
            try {
                return this.unpack(cli, components);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
        if (cli.hasOption(INDEX) && cli.hasOption(REPO)) {
            try {
                return this.index(cli, components);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
        System.out.println();
        System.out.println("Use either unpack (\"u\") or index (\"i\" and \"r\") options, but none has been found!");
        System.out.println();
        this.displayHelp();
        return 1;
    }

    Options buildCliOptions() {
        this.options = new Options();
        this.options.addOption(Option.builder((String)QUIET).longOpt("quiet").desc("Quiet output - only show errors").build());
        this.options.addOption(Option.builder((String)DEBUG).longOpt("debug").desc("Produce execution debug output").build());
        this.options.addOption(Option.builder((String)VERSION).longOpt("version").desc("Display version information").build());
        this.options.addOption(Option.builder((String)HELP).longOpt("help").desc("Display help information").build());
        this.options.addOption(Option.builder((String)INDEX).longOpt("index").argName("path").hasArg().desc("Path to the index folder").build());
        this.options.addOption(Option.builder((String)TARGET_DIR).longOpt("destination").argName("path").hasArg().desc("Target folder").build());
        this.options.addOption(Option.builder((String)REPO).longOpt("repository").argName("path").hasArg().desc("Path to the Maven repository").build());
        this.options.addOption(Option.builder((String)NAME).longOpt("name").argName("string").hasArg().desc("Repository name").build());
        this.options.addOption(Option.builder((String)CREATE_INCREMENTAL_CHUNKS).longOpt("chunks").desc("Create incremental chunks").build());
        this.options.addOption(Option.builder((String)INCREMENTAL_CHUNK_KEEP_COUNT).longOpt("keep").argName("num").hasArg().desc("Number of incremental chunks to keep").build());
        this.options.addOption(Option.builder((String)CREATE_FILE_CHECKSUMS).longOpt("checksums").desc("Create checksums for all files (sha1, md5)").build());
        this.options.addOption(Option.builder((String)TYPE).longOpt("type").argName("type").hasArg().desc("Indexer type (default, min, full or comma separated list of custom types)").build());
        this.options.addOption(Option.builder((String)UNPACK).longOpt("unpack").desc("Unpack an index file").build());
        return this.options;
    }

    private String[] cleanArgs(String[] args) {
        int cleanedSz;
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuilder currentArg = null;
        for (String arg : args) {
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuilder(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        String[] cleanArgs = (cleanedSz = cleaned.size()) == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    private void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("nexus-indexer [options]", "\nOptions:", this.options, "\n");
    }

    private void showVersion() {
        try {
            Properties properties = new Properties();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven.indexer/indexer-core/pom.properties");
            if (is == null) {
                System.err.println("Unable determine version from JAR file.");
                return;
            }
            properties.load(is);
            if (properties.getProperty("builtOn") != null) {
                System.out.println("Version: " + properties.getProperty("version", "unknown") + " built on " + properties.getProperty("builtOn"));
            } else {
                System.out.println("Version: " + properties.getProperty("version", "unknown"));
            }
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int index(CommandLine cli, Components components) throws IOException, UnsupportedExistingLuceneIndexException {
        Integer chunkCount;
        String indexDirectoryName = cli.getOptionValue(INDEX);
        File indexFolder = new File(indexDirectoryName);
        String outputDirectoryName = cli.getOptionValue(TARGET_DIR, ".");
        File outputFolder = new File(outputDirectoryName);
        File repositoryFolder = new File(cli.getOptionValue(REPO));
        String repositoryName = cli.getOptionValue(NAME, indexFolder.getName());
        List<IndexCreator> indexers = this.getIndexers(cli, components);
        boolean createChecksums = cli.hasOption(CREATE_FILE_CHECKSUMS);
        boolean createIncrementalChunks = cli.hasOption(CREATE_INCREMENTAL_CHUNKS);
        boolean debug = cli.hasOption(DEBUG);
        boolean quiet = cli.hasOption(QUIET);
        Integer n = chunkCount = cli.hasOption(INCREMENTAL_CHUNK_KEEP_COUNT) ? Integer.valueOf(Integer.parseInt(cli.getOptionValue(INCREMENTAL_CHUNK_KEEP_COUNT))) : null;
        if (!quiet) {
            System.err.printf("Repository Folder: %s\n", repositoryFolder.getAbsolutePath());
            System.err.printf("Index Folder:      %s\n", indexFolder.getAbsolutePath());
            System.err.printf("Output Folder:     %s\n", outputFolder.getAbsolutePath());
            System.err.printf("Repository name:   %s\n", repositoryName);
            System.err.printf("Indexers: %s\n", indexers);
            if (createChecksums) {
                System.err.print("Will create checksum files for all published files (sha1, md5).\n");
            } else {
                System.err.print("Will not create checksum files.\n");
            }
            if (createIncrementalChunks) {
                System.err.print("Will create incremental chunks for changes, along with baseline file.\n");
            } else {
                System.err.print("Will create baseline file.\n");
            }
        }
        long tstart = System.currentTimeMillis();
        IndexingContext context = components.indexer.addIndexingContext(repositoryName, repositoryName, repositoryFolder, indexFolder, null, null, indexers);
        try {
            IndexerListener listener = new IndexerListener(context, debug, quiet);
            components.indexer.scan(context, (ArtifactScanningListener)listener, true);
            IndexSearcher indexSearcher = context.acquireIndexSearcher();
            try {
                IndexPackingRequest request = new IndexPackingRequest(context, indexSearcher.getIndexReader(), outputFolder);
                request.setCreateChecksumFiles(createChecksums);
                request.setCreateIncrementalChunks(createIncrementalChunks);
                request.setFormats(List.of(IndexPackingRequest.IndexFormat.FORMAT_V1));
                if (chunkCount != null) {
                    request.setMaxIndexChunks(chunkCount.intValue());
                }
                this.packIndex(components.packer, request, debug, quiet);
            }
            finally {
                context.releaseIndexSearcher(indexSearcher);
            }
            if (!quiet) {
                this.printStats(tstart);
            }
        }
        finally {
            components.indexer.removeIndexingContext(context, false);
        }
        return 0;
    }

    private int unpack(CommandLine cli, Components components) throws IOException {
        String indexDirectoryName = cli.getOptionValue(INDEX, ".");
        File indexFolder = new File(indexDirectoryName).getCanonicalFile();
        File indexArchive = new File(indexFolder, "nexus-maven-repository-index.gz");
        String outputDirectoryName = cli.getOptionValue(TARGET_DIR, ".");
        File outputFolder = new File(outputDirectoryName).getCanonicalFile();
        boolean quiet = cli.hasOption(QUIET);
        if (!quiet) {
            System.err.printf("Index Folder:      %s\n", indexFolder.getAbsolutePath());
            System.err.printf("Output Folder:     %s\n", outputFolder.getAbsolutePath());
        }
        long tstart = System.currentTimeMillis();
        final List<IndexCreator> indexers = this.getIndexers(cli, components);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(indexArchive));
             FSDirectory directory = FSDirectory.open((Path)outputFolder.toPath());){
            DefaultIndexUpdater.unpackIndexData((InputStream)is, (int)4, (Directory)directory, (IndexingContext)((IndexingContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IndexingContext.class}, (InvocationHandler)new PartialImplementation(){

                public List<IndexCreator> getIndexCreators() {
                    return indexers;
                }
            })));
        }
        if (!quiet) {
            this.printStats(tstart);
        }
        return 0;
    }

    private List<IndexCreator> getIndexers(CommandLine cli, Components components) {
        String type = "default";
        if (cli.hasOption(TYPE)) {
            type = cli.getOptionValue(TYPE);
        }
        ArrayList<IndexCreator> indexers = new ArrayList<IndexCreator>();
        if ("default".equals(type)) {
            indexers.add(Objects.requireNonNull(components.allIndexCreators.get("min")));
            indexers.add(Objects.requireNonNull(components.allIndexCreators.get("jarContent")));
        } else if ("full".equals(type)) {
            indexers.addAll(components.allIndexCreators.values());
        } else {
            for (String name : type.split(",")) {
                indexers.add(Objects.requireNonNull(components.allIndexCreators.get(name)));
            }
        }
        return indexers;
    }

    private void packIndex(IndexPacker packer, IndexPackingRequest request, boolean debug, boolean quiet) {
        block2: {
            try {
                packer.packIndex(request);
            }
            catch (IOException e) {
                if (quiet) break block2;
                System.err.printf("Cannot zip index: %s\n", e.getMessage());
                if (!debug) break block2;
                e.printStackTrace();
            }
        }
    }

    private void printStats(long startTimeInMillis) {
        long t = System.currentTimeMillis() - startTimeInMillis;
        long s = TimeUnit.MILLISECONDS.toSeconds(t);
        if (t > TimeUnit.MINUTES.toMillis(1L)) {
            long m = TimeUnit.MILLISECONDS.toMinutes(t);
            System.err.printf("Total time:   %d min %d sec\n", m, s - m * 60L);
        } else {
            System.err.printf("Total time:   %d sec\n", s);
        }
        Runtime r = Runtime.getRuntime();
        System.err.printf("Final memory: %dM/%dM\n", (r.totalMemory() - r.freeMemory()) / 0x100000L, r.totalMemory() / 0x100000L);
    }

    private static final class IndexerListener
    implements ArtifactScanningListener {
        private final IndexingContext context;
        private final boolean debug;
        private final boolean quiet;
        private long ts = System.currentTimeMillis();
        private int count;

        IndexerListener(IndexingContext context, boolean debug, boolean quiet) {
            this.context = context;
            this.debug = debug;
            this.quiet = quiet;
        }

        public void scanningStarted(IndexingContext context) {
            if (!this.quiet) {
                System.err.println("Scanning started");
            }
        }

        public void artifactDiscovered(ArtifactContext ac) {
            ++this.count;
            long t = System.currentTimeMillis();
            ArtifactInfo ai = ac.getArtifactInfo();
            if (!this.quiet && this.debug && "maven-plugin".equals(ai.getPackaging())) {
                System.err.printf("Plugin: %s:%s:%s - %s %s\n", ai.getGroupId(), ai.getArtifactId(), ai.getVersion(), ai.getPrefix(), "" + ai.getGoals());
            }
            if (!this.quiet && (this.debug || t - this.ts > 2000L)) {
                System.err.printf("  %6d %s\n", this.count, this.formatFile(ac.getPom()));
                this.ts = t;
            }
        }

        public void artifactError(ArtifactContext ac, Exception e) {
            if (!this.quiet) {
                System.err.printf("! %6d %s - %s\n", this.count, this.formatFile(ac.getPom()), e.getMessage());
                System.err.printf("         %s\n", this.formatFile(ac.getArtifact()));
                if (this.debug) {
                    e.printStackTrace();
                }
            }
            this.ts = System.currentTimeMillis();
        }

        private String formatFile(File file) {
            return file.getAbsolutePath().substring(this.context.getRepository().getAbsolutePath().length() + 1);
        }

        public void scanningFinished(IndexingContext context, ScanningResult result) {
            if (!this.quiet) {
                if (result.hasExceptions()) {
                    System.err.printf("Scanning errors:   %s\n", result.getExceptions().size());
                }
                System.err.printf("Artifacts added:   %s\n", result.getTotalFiles());
                System.err.printf("Artifacts deleted: %s\n", result.getDeletedFiles());
            }
        }
    }
}

