/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FutureArrays;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.SloppyMath;

final class LatLonPointDistanceFeatureQuery
extends Query {
    private final String field;
    private final double originLat;
    private final double originLon;
    private final double pivotDistance;

    LatLonPointDistanceFeatureQuery(String field, double originLat, double originLon, double pivotDistance) {
        this.field = Objects.requireNonNull(field);
        GeoUtils.checkLatitude(originLat);
        GeoUtils.checkLongitude(originLon);
        this.originLon = originLon;
        this.originLat = originLat;
        if (pivotDistance <= 0.0) {
            throw new IllegalArgumentException("pivotDistance must be > 0, got " + pivotDistance);
        }
        this.pivotDistance = pivotDistance;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((LatLonPointDistanceFeatureQuery)this.getClass().cast(o));
    }

    private boolean equalsTo(LatLonPointDistanceFeatureQuery other) {
        return Objects.equals(this.field, other.field) && this.originLon == other.originLon && this.originLat == other.originLat && this.pivotDistance == other.pivotDistance;
    }

    @Override
    public int hashCode() {
        int h2 = this.classHash();
        h2 = 31 * h2 + this.field.hashCode();
        h2 = 31 * h2 + Double.hashCode(this.originLat);
        h2 = 31 * h2 + Double.hashCode(this.originLon);
        h2 = 31 * h2 + Double.hashCode(this.pivotDistance);
        return h2;
    }

    @Override
    public String toString(String field) {
        return this.getClass().getSimpleName() + "(field=" + field + ",originLat=" + this.originLat + ",originLon=" + this.originLon + ",pivotDistance=" + this.pivotDistance + ")";
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        return new Weight(this){

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                SortedNumericDocValues multiDocValues = DocValues.getSortedNumeric(context.reader(), LatLonPointDistanceFeatureQuery.this.field);
                if (!multiDocValues.advanceExact(doc)) {
                    return Explanation.noMatch("Document " + doc + " doesn't have a value for field " + LatLonPointDistanceFeatureQuery.this.field, new Explanation[0]);
                }
                long encoded = this.selectValue(multiDocValues);
                int latitudeBits = (int)(encoded >> 32);
                int longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL);
                double lat = GeoEncodingUtils.decodeLatitude(latitudeBits);
                double lon = GeoEncodingUtils.decodeLongitude(longitudeBits);
                double distance = SloppyMath.haversinMeters(LatLonPointDistanceFeatureQuery.this.originLat, LatLonPointDistanceFeatureQuery.this.originLon, lat, lon);
                float score = (float)((double)boost * (LatLonPointDistanceFeatureQuery.this.pivotDistance / (LatLonPointDistanceFeatureQuery.this.pivotDistance + distance)));
                return Explanation.match((Number)Float.valueOf(score), "Distance score, computed as weight * pivotDistance / (pivotDistance + abs(distance)) from:", Explanation.match((Number)Float.valueOf(boost), "weight", new Explanation[0]), Explanation.match((Number)LatLonPointDistanceFeatureQuery.this.pivotDistance, "pivotDistance", new Explanation[0]), Explanation.match((Number)LatLonPointDistanceFeatureQuery.this.originLat, "originLat", new Explanation[0]), Explanation.match((Number)LatLonPointDistanceFeatureQuery.this.originLon, "originLon", new Explanation[0]), Explanation.match((Number)lat, "current lat", new Explanation[0]), Explanation.match((Number)lon, "current lon", new Explanation[0]), Explanation.match((Number)distance, "distance", new Explanation[0]));
            }

            private long selectValue(SortedNumericDocValues multiDocValues) throws IOException {
                int count = multiDocValues.docValueCount();
                long value = multiDocValues.nextValue();
                if (count == 1) {
                    return value;
                }
                double distance = LatLonPointDistanceFeatureQuery.this.getDistanceKeyFromEncoded(value);
                for (int i = 1; i < count; ++i) {
                    long nextValue = multiDocValues.nextValue();
                    double nextDistance = LatLonPointDistanceFeatureQuery.this.getDistanceKeyFromEncoded(nextValue);
                    if (!(nextDistance < distance)) continue;
                    distance = nextDistance;
                    value = nextValue;
                }
                return value;
            }

            private NumericDocValues selectValues(final SortedNumericDocValues multiDocValues) {
                NumericDocValues singleton = DocValues.unwrapSingleton(multiDocValues);
                if (singleton != null) {
                    return singleton;
                }
                return new NumericDocValues(){
                    long value;

                    @Override
                    public long longValue() throws IOException {
                        return this.value;
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (multiDocValues.advanceExact(target)) {
                            this.value = this.selectValue(multiDocValues);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public int docID() {
                        return multiDocValues.docID();
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        return multiDocValues.nextDoc();
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        return multiDocValues.advance(target);
                    }

                    @Override
                    public long cost() {
                        return multiDocValues.cost();
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final PointValues pointValues = context.reader().getPointValues(LatLonPointDistanceFeatureQuery.this.field);
                if (pointValues == null) {
                    return null;
                }
                SortedNumericDocValues multiDocValues = DocValues.getSortedNumeric(context.reader(), LatLonPointDistanceFeatureQuery.this.field);
                final NumericDocValues docValues = this.selectValues(multiDocValues);
                final 1 weight = this;
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        return new DistanceScorer(weight, context.reader().maxDoc(), leadCost, boost, pointValues, docValues);
                    }

                    @Override
                    public long cost() {
                        return docValues.cost();
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }
        };
    }

    private double getDistanceFromEncoded(long encoded) {
        return SloppyMath.haversinMeters(this.getDistanceKeyFromEncoded(encoded));
    }

    private double getDistanceKeyFromEncoded(long encoded) {
        int latitudeBits = (int)(encoded >> 32);
        int longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL);
        double lat = GeoEncodingUtils.decodeLatitude(latitudeBits);
        double lon = GeoEncodingUtils.decodeLongitude(longitudeBits);
        return SloppyMath.haversinSortKey(this.originLat, this.originLon, lat, lon);
    }

    private class DistanceScorer
    extends Scorer {
        private final int maxDoc;
        private DocIdSetIterator it;
        private int doc;
        private final long leadCost;
        private final float boost;
        private final PointValues pointValues;
        private final NumericDocValues docValues;
        private double maxDistance;
        private int setMinCompetitiveScoreCounter;

        protected DistanceScorer(Weight weight, int maxDoc, long leadCost, float boost, PointValues pointValues, NumericDocValues docValues) {
            super(weight);
            this.doc = -1;
            this.maxDistance = 2.0015114352186374E7;
            this.setMinCompetitiveScoreCounter = 0;
            this.maxDoc = maxDoc;
            this.leadCost = leadCost;
            this.boost = boost;
            this.pointValues = pointValues;
            this.docValues = docValues;
            this.it = docValues;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private float score(double distance) {
            return (float)((double)this.boost * (LatLonPointDistanceFeatureQuery.this.pivotDistance / (LatLonPointDistanceFeatureQuery.this.pivotDistance + distance)));
        }

        private double computeMaxDistance(float minScore, double previousMaxDistance) {
            assert (this.score(0.0) >= minScore);
            if (this.score(previousMaxDistance) >= minScore) {
                return previousMaxDistance;
            }
            assert (this.score(previousMaxDistance) < minScore);
            double min2 = 0.0;
            double max = previousMaxDistance;
            while (max - min2 > 1.0) {
                double mid = (min2 + max) / 2.0;
                float score = this.score(mid);
                if (score >= minScore) {
                    min2 = mid;
                    continue;
                }
                max = mid;
            }
            assert (this.score(min2) >= minScore);
            assert (min2 == Double.MAX_VALUE || this.score(min2 + 1.0) < minScore);
            return min2;
        }

        @Override
        public float score() throws IOException {
            if (!this.docValues.advanceExact(this.docID())) {
                return 0.0f;
            }
            return this.score(LatLonPointDistanceFeatureQuery.this.getDistanceFromEncoded(this.docValues.longValue()));
        }

        @Override
        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                @Override
                public int nextDoc() throws IOException {
                    return DistanceScorer.this.doc = DistanceScorer.this.it.nextDoc();
                }

                @Override
                public int docID() {
                    return DistanceScorer.this.doc;
                }

                @Override
                public long cost() {
                    return DistanceScorer.this.it.cost();
                }

                @Override
                public int advance(int target) throws IOException {
                    return DistanceScorer.this.doc = DistanceScorer.this.it.advance(target);
                }
            };
        }

        @Override
        public float getMaxScore(int upTo) {
            return this.boost;
        }

        @Override
        public void setMinCompetitiveScore(float minScore) throws IOException {
            if (minScore > this.boost) {
                this.it = DocIdSetIterator.empty();
                return;
            }
            ++this.setMinCompetitiveScoreCounter;
            if (this.setMinCompetitiveScoreCounter > 256 && (this.setMinCompetitiveScoreCounter & 0x1F) != 31) {
                return;
            }
            double previousMaxDistance = this.maxDistance;
            this.maxDistance = this.computeMaxDistance(minScore, this.maxDistance);
            if (this.maxDistance == previousMaxDistance) {
                return;
            }
            Rectangle box = Rectangle.fromPointDistance(LatLonPointDistanceFeatureQuery.this.originLat, LatLonPointDistanceFeatureQuery.this.originLon, this.maxDistance);
            final byte[] minLat = new byte[4];
            final byte[] maxLat = new byte[4];
            final byte[] minLon = new byte[4];
            final byte[] maxLon = new byte[4];
            final boolean crossDateLine = box.crossesDateline();
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box.minLat), minLat, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(box.maxLat), maxLat, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.minLon), minLon, 0);
            NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(box.maxLon), maxLon, 0);
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            final int doc = this.docID();
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                @Override
                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                @Override
                public void visit(int docID) {
                    if (docID <= doc) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public void visit(int docID, byte[] packedValue) {
                    if (docID <= doc) {
                        return;
                    }
                    if (FutureArrays.compareUnsigned(packedValue, 0, 4, maxLat, 0, 4) > 0 || FutureArrays.compareUnsigned(packedValue, 0, 4, minLat, 0, 4) < 0) {
                        return;
                    }
                    if (crossDateLine ? FutureArrays.compareUnsigned(packedValue, 4, 8, minLon, 0, 4) < 0 && FutureArrays.compareUnsigned(packedValue, 4, 8, maxLon, 0, 4) > 0 : FutureArrays.compareUnsigned(packedValue, 4, 8, maxLon, 0, 4) > 0 || FutureArrays.compareUnsigned(packedValue, 4, 8, minLon, 0, 4) < 0) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    boolean crosses;
                    if (FutureArrays.compareUnsigned(minPackedValue, 0, 4, maxLat, 0, 4) > 0 || FutureArrays.compareUnsigned(maxPackedValue, 0, 4, minLat, 0, 4) < 0) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    boolean bl = crosses = FutureArrays.compareUnsigned(minPackedValue, 0, 4, minLat, 0, 4) < 0 || FutureArrays.compareUnsigned(maxPackedValue, 0, 4, maxLat, 0, 4) > 0;
                    if (crossDateLine) {
                        if (FutureArrays.compareUnsigned(minPackedValue, 4, 8, maxLon, 0, 4) > 0 && FutureArrays.compareUnsigned(maxPackedValue, 4, 8, minLon, 0, 4) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        crosses |= FutureArrays.compareUnsigned(minPackedValue, 4, 8, maxLon, 0, 4) < 0 || FutureArrays.compareUnsigned(maxPackedValue, 4, 8, minLon, 0, 4) > 0;
                    } else {
                        if (FutureArrays.compareUnsigned(minPackedValue, 4, 8, maxLon, 0, 4) > 0 || FutureArrays.compareUnsigned(maxPackedValue, 4, 8, minLon, 0, 4) < 0) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        crosses |= FutureArrays.compareUnsigned(minPackedValue, 4, 8, minLon, 0, 4) < 0 || FutureArrays.compareUnsigned(maxPackedValue, 4, 8, maxLon, 0, 4) > 0;
                    }
                    if (crosses) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long currentQueryCost = Math.min(this.leadCost, this.it.cost());
            long threshold = currentQueryCost >>> 3;
            long estimatedNumberOfMatches = this.pointValues.estimatePointCount(visitor);
            if (estimatedNumberOfMatches >= threshold) {
                return;
            }
            this.pointValues.intersect(visitor);
            this.it = result.build().iterator();
        }
    }
}

