/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;

public class IndexSortSortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;
    private final Query fallbackQuery;

    public IndexSortSortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue, Query fallbackQuery) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.fallbackQuery = fallbackQuery;
    }

    public Query getFallbackQuery() {
        return this.fallbackQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSortSortedNumericDocValuesRangeQuery that = (IndexSortSortedNumericDocValuesRangeQuery)o;
        return this.lowerValue == that.lowerValue && this.upperValue == that.upperValue && Objects.equals(this.field, that.field) && Objects.equals(this.fallbackQuery, that.fallbackQuery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.lowerValue, this.upperValue, this.fallbackQuery);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
            this.fallbackQuery.visit(visitor);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new DocValuesFieldExistsQuery(this.field);
        }
        Query rewrittenFallback = this.fallbackQuery.rewrite(reader);
        if (rewrittenFallback == this.fallbackQuery) {
            return this;
        }
        return new IndexSortSortedNumericDocValuesRangeQuery(this.field, this.lowerValue, this.upperValue, rewrittenFallback);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight fallbackWeight = this.fallbackQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Sort indexSort;
                SortedNumericDocValues sortedNumericValues = DocValues.getSortedNumeric(context.reader(), IndexSortSortedNumericDocValuesRangeQuery.this.field);
                NumericDocValues numericValues = DocValues.unwrapSingleton(sortedNumericValues);
                if (numericValues != null && (indexSort = context.reader().getMetaData().getSort()) != null && indexSort.getSort().length > 0 && indexSort.getSort()[0].getField().equals(IndexSortSortedNumericDocValuesRangeQuery.this.field)) {
                    SortField sortField = indexSort.getSort()[0];
                    DocIdSetIterator disi = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIterator(sortField, context, numericValues);
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, disi);
                }
                return fallbackWeight.scorer(context);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return fallbackWeight.isCacheable(ctx);
            }
        };
    }

    private DocIdSetIterator getDocIdSetIterator(SortField sortField, LeafReaderContext context, DocIdSetIterator delegate) throws IOException {
        long lower = sortField.getReverse() ? this.upperValue : this.lowerValue;
        long upper = sortField.getReverse() ? this.lowerValue : this.upperValue;
        int maxDoc = context.reader().maxDoc();
        ValueComparator comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, lower, context);
        int low = 0;
        int high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) <= 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, lower, context);
                continue;
            }
            low = mid + 1;
        }
        int firstDocIdInclusive = high + 1;
        comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, upper, context);
        low = firstDocIdInclusive;
        high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) < 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, upper, context);
                continue;
            }
            low = mid + 1;
        }
        int lastDocIdExclusive = high + 1;
        return new BoundedDocSetIdIterator(firstDocIdInclusive, lastDocIdExclusive, delegate);
    }

    private static ValueComparator loadComparator(SortField sortField, long topValue, LeafReaderContext context) throws IOException {
        FieldComparator<?> fieldComparator = sortField.getComparator(1, 0);
        fieldComparator.setTopValue(topValue);
        LeafFieldComparator leafFieldComparator = fieldComparator.getLeafComparator(context);
        int direction = sortField.getReverse() ? -1 : 1;
        return doc -> {
            int value = leafFieldComparator.compareTop(doc);
            return direction * value;
        };
    }

    private static class BoundedDocSetIdIterator
    extends DocIdSetIterator {
        private final int firstDoc;
        private final int lastDoc;
        private final DocIdSetIterator delegate;
        private int docID = -1;

        BoundedDocSetIdIterator(int firstDoc, int lastDoc, DocIdSetIterator delegate) {
            this.firstDoc = firstDoc;
            this.lastDoc = lastDoc;
            this.delegate = delegate;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int result;
            if (target < this.firstDoc) {
                target = this.firstDoc;
            }
            this.docID = (result = this.delegate.advance(target)) < this.lastDoc ? result : Integer.MAX_VALUE;
            return this.docID;
        }

        @Override
        public long cost() {
            return this.lastDoc - this.firstDoc;
        }
    }

    private static interface ValueComparator {
        public int compare(int var1) throws IOException;
    }
}

