/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.custom;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilter;
import org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilterFactory;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.AnalysisSPILoader;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ClasspathResourceLoader;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.Version;

public final class CustomAnalyzer
extends Analyzer {
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] tokenFilters;
    private final Integer posIncGap;
    private final Integer offsetGap;

    public static Builder builder() {
        return CustomAnalyzer.builder(new ClasspathResourceLoader(CustomAnalyzer.class.getClassLoader()));
    }

    public static Builder builder(Path configDir) {
        return CustomAnalyzer.builder(new FilesystemResourceLoader(configDir, CustomAnalyzer.class.getClassLoader()));
    }

    public static Builder builder(ResourceLoader loader) {
        return new Builder(loader);
    }

    CustomAnalyzer(Version defaultMatchVersion, CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] tokenFilters, Integer posIncGap, Integer offsetGap) {
        this.charFilters = charFilters;
        this.tokenizer = tokenizer;
        this.tokenFilters = tokenFilters;
        this.posIncGap = posIncGap;
        this.offsetGap = offsetGap;
        if (defaultMatchVersion != null) {
            this.setVersion(defaultMatchVersion);
        }
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        for (CharFilterFactory charFilter : this.charFilters) {
            reader = charFilter.create(reader);
        }
        return reader;
    }

    @Override
    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        for (CharFilterFactory charFilter : this.charFilters) {
            reader = charFilter.normalize(reader);
        }
        return reader;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tk;
        TokenStream ts = tk = this.tokenizer.create(this.attributeFactory(fieldName));
        for (TokenFilterFactory filter : this.tokenFilters) {
            ts = filter.create(ts);
        }
        return new Analyzer.TokenStreamComponents(tk, ts);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream result = in;
        for (TokenFilterFactory filter : this.tokenFilters) {
            result = filter.normalize(result);
        }
        return result;
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return this.posIncGap == null ? super.getPositionIncrementGap(fieldName) : this.posIncGap.intValue();
    }

    @Override
    public int getOffsetGap(String fieldName) {
        return this.offsetGap == null ? super.getOffsetGap(fieldName) : this.offsetGap.intValue();
    }

    public List<CharFilterFactory> getCharFilterFactories() {
        return Collections.unmodifiableList(Arrays.asList(this.charFilters));
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizer;
    }

    public List<TokenFilterFactory> getTokenFilterFactories() {
        return Collections.unmodifiableList(Arrays.asList(this.tokenFilters));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('(');
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory).append(',');
        }
        sb.append(this.tokenizer);
        for (AbstractAnalysisFactory abstractAnalysisFactory : this.tokenFilters) {
            sb.append(',').append(abstractAnalysisFactory);
        }
        return sb.append(')').toString();
    }

    public static class ConditionBuilder {
        private final List<TokenFilterFactory> innerFilters = new ArrayList<TokenFilterFactory>();
        private final ConditionalTokenFilterFactory factory;
        private final Builder parent;

        private ConditionBuilder(ConditionalTokenFilterFactory factory, Builder parent) {
            this.factory = factory;
            this.parent = parent;
        }

        public ConditionBuilder addTokenFilter(String name, Map<String, String> params) throws IOException {
            this.innerFilters.add(TokenFilterFactory.forName(name, this.parent.applyDefaultParams(params)));
            return this;
        }

        public ConditionBuilder addTokenFilter(String name, String ... params) throws IOException {
            return this.addTokenFilter(name, (Map<String, String>)this.parent.paramsToMap(params));
        }

        public ConditionBuilder addTokenFilter(Class<? extends TokenFilterFactory> factory, Map<String, String> params) throws IOException {
            this.innerFilters.add(AnalysisSPILoader.newFactoryClassInstance(factory, this.parent.applyDefaultParams(params)));
            return this;
        }

        public ConditionBuilder addTokenFilter(Class<? extends TokenFilterFactory> factory, String ... params) throws IOException {
            return this.addTokenFilter(factory, (Map<String, String>)this.parent.paramsToMap(params));
        }

        public Builder endwhen() throws IOException {
            this.factory.setInnerFilters(this.innerFilters);
            this.parent.applyResourceLoader(this.factory);
            this.parent.addTokenFilter(this.factory);
            return this.parent;
        }
    }

    public static final class Builder {
        private final ResourceLoader loader;
        private final SetOnce<Version> defaultMatchVersion = new SetOnce();
        private final List<CharFilterFactory> charFilters = new ArrayList<CharFilterFactory>();
        private final SetOnce<TokenizerFactory> tokenizer = new SetOnce();
        private final List<TokenFilterFactory> tokenFilters = new ArrayList<TokenFilterFactory>();
        private final SetOnce<Integer> posIncGap = new SetOnce();
        private final SetOnce<Integer> offsetGap = new SetOnce();
        private boolean componentsAdded = false;

        Builder(ResourceLoader loader) {
            this.loader = loader;
        }

        public Builder withDefaultMatchVersion(Version version) {
            Objects.requireNonNull(version, "version may not be null");
            if (this.componentsAdded) {
                throw new IllegalStateException("You may only set the default match version before adding tokenizers, token filters, or char filters.");
            }
            this.defaultMatchVersion.set(version);
            return this;
        }

        public Builder withPositionIncrementGap(int posIncGap) {
            if (posIncGap < 0) {
                throw new IllegalArgumentException("posIncGap must be >= 0");
            }
            this.posIncGap.set(posIncGap);
            return this;
        }

        public Builder withOffsetGap(int offsetGap) {
            if (offsetGap < 0) {
                throw new IllegalArgumentException("offsetGap must be >= 0");
            }
            this.offsetGap.set(offsetGap);
            return this;
        }

        public Builder withTokenizer(Class<? extends TokenizerFactory> factory, String ... params) throws IOException {
            return this.withTokenizer(factory, this.paramsToMap(params));
        }

        public Builder withTokenizer(Class<? extends TokenizerFactory> factory, Map<String, String> params) throws IOException {
            Objects.requireNonNull(factory, "Tokenizer factory may not be null");
            this.tokenizer.set(this.applyResourceLoader(AnalysisSPILoader.newFactoryClassInstance(factory, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public Builder withTokenizer(String name, String ... params) throws IOException {
            return this.withTokenizer(name, this.paramsToMap(params));
        }

        public Builder withTokenizer(String name, Map<String, String> params) throws IOException {
            Objects.requireNonNull(name, "Tokenizer name may not be null");
            this.tokenizer.set(this.applyResourceLoader(TokenizerFactory.forName(name, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public Builder addTokenFilter(Class<? extends TokenFilterFactory> factory, String ... params) throws IOException {
            return this.addTokenFilter(factory, this.paramsToMap(params));
        }

        public Builder addTokenFilter(Class<? extends TokenFilterFactory> factory, Map<String, String> params) throws IOException {
            Objects.requireNonNull(factory, "TokenFilter name may not be null");
            this.tokenFilters.add(this.applyResourceLoader(AnalysisSPILoader.newFactoryClassInstance(factory, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public Builder addTokenFilter(String name, String ... params) throws IOException {
            return this.addTokenFilter(name, this.paramsToMap(params));
        }

        public Builder addTokenFilter(String name, Map<String, String> params) throws IOException {
            Objects.requireNonNull(name, "TokenFilter name may not be null");
            this.tokenFilters.add(this.applyResourceLoader(TokenFilterFactory.forName(name, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        private Builder addTokenFilter(TokenFilterFactory factory) {
            Objects.requireNonNull(factory, "TokenFilterFactory may not be null");
            this.tokenFilters.add(factory);
            this.componentsAdded = true;
            return this;
        }

        public Builder addCharFilter(Class<? extends CharFilterFactory> factory, String ... params) throws IOException {
            return this.addCharFilter(factory, this.paramsToMap(params));
        }

        public Builder addCharFilter(Class<? extends CharFilterFactory> factory, Map<String, String> params) throws IOException {
            Objects.requireNonNull(factory, "CharFilter name may not be null");
            this.charFilters.add(this.applyResourceLoader(AnalysisSPILoader.newFactoryClassInstance(factory, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public Builder addCharFilter(String name, String ... params) throws IOException {
            return this.addCharFilter(name, this.paramsToMap(params));
        }

        public Builder addCharFilter(String name, Map<String, String> params) throws IOException {
            Objects.requireNonNull(name, "CharFilter name may not be null");
            this.charFilters.add(this.applyResourceLoader(CharFilterFactory.forName(name, this.applyDefaultParams(params))));
            this.componentsAdded = true;
            return this;
        }

        public ConditionBuilder when(String name, String ... params) throws IOException {
            return this.when(name, this.paramsToMap(params));
        }

        public ConditionBuilder when(String name, Map<String, String> params) throws IOException {
            Class<? extends TokenFilterFactory> clazz = TokenFilterFactory.lookupClass(name);
            if (!ConditionalTokenFilterFactory.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("TokenFilterFactory " + name + " is not a ConditionalTokenFilterFactory");
            }
            return this.when(clazz, params);
        }

        public ConditionBuilder when(Class<? extends ConditionalTokenFilterFactory> factory, String ... params) throws IOException {
            return this.when(factory, this.paramsToMap(params));
        }

        public ConditionBuilder when(Class<? extends ConditionalTokenFilterFactory> factory, Map<String, String> params) throws IOException {
            return this.when(AnalysisSPILoader.newFactoryClassInstance(factory, this.applyDefaultParams(params)));
        }

        public ConditionBuilder when(ConditionalTokenFilterFactory factory) {
            return new ConditionBuilder(factory, this);
        }

        public ConditionBuilder whenTerm(final Predicate<CharSequence> predicate) {
            return new ConditionBuilder(new ConditionalTokenFilterFactory(Collections.emptyMap()){

                @Override
                protected ConditionalTokenFilter create(TokenStream input, Function<TokenStream, TokenStream> inner) {
                    return new ConditionalTokenFilter(input, inner){
                        CharTermAttribute termAtt;
                        {
                            super(input, inputFactory);
                            this.termAtt = this.addAttribute(CharTermAttribute.class);
                        }

                        @Override
                        protected boolean shouldFilter() {
                            return predicate.test(this.termAtt);
                        }
                    };
                }
            }, this);
        }

        public CustomAnalyzer build() {
            if (this.tokenizer.get() == null) {
                throw new IllegalStateException("You have to set at least a tokenizer.");
            }
            return new CustomAnalyzer(this.defaultMatchVersion.get(), this.charFilters.toArray(new CharFilterFactory[this.charFilters.size()]), this.tokenizer.get(), this.tokenFilters.toArray(new TokenFilterFactory[this.tokenFilters.size()]), this.posIncGap.get(), this.offsetGap.get());
        }

        private Map<String, String> applyDefaultParams(Map<String, String> map) {
            if (this.defaultMatchVersion.get() != null && !map.containsKey("luceneMatchVersion")) {
                map.put("luceneMatchVersion", this.defaultMatchVersion.get().toString());
            }
            return map;
        }

        private Map<String, String> paramsToMap(String ... params) {
            if (params.length % 2 != 0) {
                throw new IllegalArgumentException("Key-value pairs expected, so the number of params must be even.");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < params.length; i += 2) {
                Objects.requireNonNull(params[i], "Key of param may not be null.");
                map.put(params[i], params[i + 1]);
            }
            return map;
        }

        <T> T applyResourceLoader(T factory) throws IOException {
            if (factory instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)factory).inform(this.loader);
            }
            return factory;
        }
    }
}

