/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexingContext;

public class DefaultScannerListener
implements ArtifactScanningListener {
    private final IndexingContext context;
    private final IndexerEngine indexerEngine;
    private final boolean update;
    private final ArtifactScanningListener listener;
    private final Set<String> uinfos = new HashSet<String>();
    private final Set<String> processedUinfos = new HashSet<String>();
    private final Set<String> allGroups = new HashSet<String>();
    private final Set<String> groups = new HashSet<String>();
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private int count = 0;

    public DefaultScannerListener(IndexingContext context, IndexerEngine indexerEngine, boolean update, ArtifactScanningListener listener) {
        this.context = context;
        this.indexerEngine = indexerEngine;
        this.update = update;
        this.listener = listener;
    }

    @Override
    public void scanningStarted(IndexingContext ctx) {
        try {
            if (this.update) {
                this.initialize(ctx);
            }
        }
        catch (IOException ex) {
            this.exceptions.add(ex);
        }
        if (this.listener != null) {
            this.listener.scanningStarted(ctx);
        }
    }

    @Override
    public void artifactDiscovered(ArtifactContext ac) {
        String uinfo = ac.getArtifactInfo().getUinfo();
        if (this.processedUinfos.contains(uinfo)) {
            return;
        }
        boolean adding = this.processedUinfos.add(uinfo);
        if (this.uinfos.contains(uinfo)) {
            this.uinfos.remove(uinfo);
            return;
        }
        try {
            if (this.listener != null) {
                this.listener.artifactDiscovered(ac);
            }
            if (adding) {
                this.indexerEngine.index(this.context, ac);
            } else {
                this.indexerEngine.update(this.context, ac);
            }
            for (Exception e : ac.getErrors()) {
                this.artifactError(ac, e);
            }
            this.groups.add(ac.getArtifactInfo().getRootGroup());
            this.allGroups.add(ac.getArtifactInfo().getGroupId());
            ++this.count;
        }
        catch (IOException ex) {
            this.artifactError(ac, ex);
        }
    }

    @Override
    public void scanningFinished(IndexingContext ctx, ScanningResult result) {
        result.setTotalFiles(this.count);
        for (Exception ex : this.exceptions) {
            result.addException(ex);
        }
        try {
            this.context.optimize();
            this.context.setRootGroups(this.groups);
            this.context.setAllGroups(this.allGroups);
            if (this.update && !this.context.isReceivingUpdates()) {
                this.removeDeletedArtifacts(this.context, result, result.getRequest().getStartingPath());
            }
        }
        catch (IOException ex) {
            result.addException(ex);
        }
        if (this.listener != null) {
            this.listener.scanningFinished(ctx, result);
        }
        if (result.getDeletedFiles() > 0 || result.getTotalFiles() > 0) {
            try {
                this.context.updateTimestamp(true);
                this.context.optimize();
            }
            catch (Exception ex) {
                result.addException(ex);
            }
        }
    }

    @Override
    public void artifactError(ArtifactContext ac, Exception e) {
        this.exceptions.add(e);
        if (this.listener != null) {
            this.listener.artifactError(ac, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(IndexingContext ctx) throws IOException, CorruptIndexException {
        IndexSearcher indexSearcher = ctx.acquireIndexSearcher();
        try {
            IndexReader r = indexSearcher.getIndexReader();
            Bits liveDocs = MultiBits.getLiveDocs(r);
            for (int i = 0; i < r.maxDoc(); ++i) {
                String groupId;
                int n;
                Document d;
                String uinfo;
                if (liveDocs != null && !liveDocs.get(i) || (uinfo = (d = r.document(i)).get(ArtifactInfo.UINFO)) == null) continue;
                if (!ctx.isReceivingUpdates()) {
                    this.uinfos.add(uinfo);
                }
                this.groups.add((n = (groupId = uinfo.substring(0, uinfo.indexOf(124))).indexOf(46)) == -1 ? groupId : groupId.substring(0, n));
                this.allGroups.add(groupId);
            }
        }
        finally {
            ctx.releaseIndexSearcher(indexSearcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeletedArtifacts(IndexingContext context, ScanningResult result, String contextPath) throws IOException {
        int deleted = 0;
        IndexSearcher indexSearcher = context.acquireIndexSearcher();
        try {
            for (String uinfo : this.uinfos) {
                TopScoreDocCollector collector = TopScoreDocCollector.create(1, Integer.MAX_VALUE);
                indexSearcher.search((Query)new TermQuery(new Term(ArtifactInfo.UINFO, uinfo)), collector);
                if (collector.getTotalHits() <= 0) continue;
                String[] ra = ArtifactInfo.FS_PATTERN.split(uinfo);
                ArtifactInfo ai = new ArtifactInfo();
                ai.setRepository(context.getRepositoryId());
                ai.setGroupId(ra[0]);
                ai.setArtifactId(ra[1]);
                ai.setVersion(ra[2]);
                if (ra.length > 3) {
                    ai.setClassifier(ArtifactInfo.renvl(ra[3]));
                }
                if (ra.length > 4) {
                    ai.setPackaging(ArtifactInfo.renvl(ra[4]));
                }
                ArtifactContext ac = new ArtifactContext(null, null, null, ai, ai.calculateGav());
                for (int i = 0; i < collector.getTotalHits(); ++i) {
                    if (contextPath == null || context.getGavCalculator().gavToPath(ac.getGav()).startsWith(contextPath)) {
                        this.indexerEngine.remove(context, ac);
                    }
                    ++deleted;
                }
            }
        }
        finally {
            context.releaseIndexSearcher(indexSearcher);
        }
        if (deleted > 0) {
            context.commit();
        }
        result.setDeletedFiles(deleted);
    }
}

